/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.LongStream;
import org.codefilarete.stalactite.engine.crud.BatchInsert;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.ColumnVariable;
import org.codefilarete.stalactite.sql.order.Insert;
import org.codefilarete.stalactite.sql.order.InsertCommandBuilder;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Predicates;

public class DefaultBatchInsert<T extends Table<T>>
extends Insert<T>
implements BatchInsert<T> {
    private final List<Set<ColumnVariable<?, T>>> rows = new ArrayList();
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;

    public DefaultBatchInsert(T targetTable, Dialect dialect, ConnectionProvider connectionProvider) {
        super(targetTable);
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public <C> DefaultBatchInsert<T> set(Column<? extends T, C> column, C value) {
        super.set(column, value);
        return this;
    }

    @Override
    public BatchInsert<T> newRow() {
        this.rows.add((Set<ColumnVariable<?, T>>)new KeepOrderSet(this.getRow()));
        this.getRow().clear();
        return this;
    }

    @Override
    public long execute() {
        long[] writeCount;
        if (!this.getRow().isEmpty()) {
            this.rows.add((Set<ColumnVariable<?, T>>)new KeepOrderSet(this.getRow()));
        }
        InsertCommandBuilder.InsertStatement insertStatement = new InsertCommandBuilder(this, this.dialect).toStatement();
        try (WriteOperation writeOperation = this.dialect.getWriteOperationFactory().createInstance(insertStatement, this.connectionProvider);){
            this.rows.stream().filter(Predicates.not(Set::isEmpty)).map(row -> Iterables.map((Iterable)row, ColumnVariable::getColumn, ColumnVariable::getValue)).forEach(arg_0 -> writeOperation.addBatch(arg_0));
            writeCount = writeOperation.executeBatch();
        }
        this.rows.clear();
        this.getRow().clear();
        return LongStream.of(writeCount).sum();
    }
}

