/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public class Column<T extends Table, O>
implements Selectable<O>,
JoinLink<T, O> {
    private final T table;
    private final String name;
    private final Class<O> javaType;
    @Nullable
    private Size size;
    @Nullable
    private Boolean nullable;
    private final String absoluteName;
    private final String alias;
    private boolean primaryKey;
    private boolean autoGenerated;

    public Column(T owner, String name, Class<O> javaType) {
        this(owner, name, javaType, null);
    }

    public Column(T owner, String name, Class<O> javaType, @Nullable Size size) {
        this.table = owner;
        this.name = name;
        this.javaType = javaType;
        this.size = size;
        this.absoluteName = ((Table)this.getTable()).getName() + "." + this.getName();
        this.alias = ((Table)this.getTable()).getName() + "_" + this.getName();
        this.nullable = null;
    }

    public Column(T owner, String name, Class<O> javaType, @Nullable Size size, @Nullable Boolean nullable) {
        this.table = owner;
        this.name = name;
        this.javaType = javaType;
        this.size = size;
        this.absoluteName = ((Table)this.getTable()).getName() + "." + this.getName();
        this.alias = ((Table)this.getTable()).getName() + "_" + this.getName();
        this.nullable = nullable;
    }

    @Override
    public T getOwner() {
        return this.getTable();
    }

    @Override
    public String getExpression() {
        return this.name;
    }

    @Override
    public Class<O> getJavaType() {
        return this.javaType;
    }

    public T getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsoluteName() {
        return this.absoluteName;
    }

    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public Size getSize() {
        return this.size;
    }

    public void setSize(@Nullable Size size) {
        this.size = size;
    }

    @Nullable
    public Boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Column<T, O> nullable(boolean nullable) {
        this.setNullable(nullable);
        return this;
    }

    public Column<T, O> notNull() {
        return this.nullable(false);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Column<T, O> primaryKey() {
        this.setPrimaryKey(true);
        return this;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        if (!this.isPrimaryKey() && autoGenerated) {
            throw new UnsupportedOperationException("Auto generate operation is only supported for primary key, please declare the column as primary key before");
        }
        this.autoGenerated = autoGenerated;
    }

    public Column<T, O> autoGenerated() {
        this.setAutoGenerated(true);
        return this;
    }

    public String toString() {
        return this.getAbsoluteName();
    }
}

