/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public class ComposedIdMapping<C, I>
implements IdMapping<C, I> {
    private final IdAccessor<C, I> idAccessor;
    private final AlreadyAssignedIdentifierManager<C, I> identifierInsertionManager;
    private final ComposedIdentifierAssembler<I, ?> identifierMarshaller;

    public ComposedIdMapping(IdAccessor<C, I> idAccessor, AlreadyAssignedIdentifierManager<C, I> identifierInsertionManager, ComposedIdentifierAssembler<I, ?> identifierMarshaller) {
        this.idAccessor = idAccessor;
        this.identifierInsertionManager = identifierInsertionManager;
        this.identifierMarshaller = identifierMarshaller;
    }

    public ComposedIdMapping(ReversibleAccessor<C, I> identifierAccessor, AlreadyAssignedIdentifierManager<C, I> identifierInsertionManager, ComposedIdentifierAssembler<I, ?> identifierMarshaller) {
        this(new AccessorWrapperIdAccessor<C, I>(identifierAccessor), identifierInsertionManager, identifierMarshaller);
    }

    @Override
    public IdAccessor<C, I> getIdAccessor() {
        return this.idAccessor;
    }

    @Override
    public <T extends Table<T>> IdentifierAssembler<I, T> getIdentifierAssembler() {
        return this.identifierMarshaller;
    }

    @Override
    public AlreadyAssignedIdentifierManager<C, I> getIdentifierInsertionManager() {
        return this.identifierInsertionManager;
    }

    @Override
    public boolean isNew(C entity) {
        return this.identifierInsertionManager.getIsPersistedFunction().apply(entity) == false;
    }
}

