/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.hsqldb.statement.binder;

import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.hsqldb.statement.binder.HSQLDBParameterBinderRegistry;
import org.codefilarete.stalactite.sql.hsqldb.statement.binder.HSQLDBTypeMapping;
import org.codefilarete.stalactite.sql.hsqldb.test.HSQLDBDatabaseHelper;
import org.codefilarete.stalactite.sql.hsqldb.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.sql.statement.binder.AbstractParameterBindersITTest;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HSQLDBParameterBindersTest
extends AbstractParameterBindersITTest {
    HSQLDBParameterBindersTest() {
    }

    public DataSource giveDataSource() {
        return new HSQLDBInMemoryDataSource();
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new HSQLDBDatabaseHelper();
    }

    @BeforeEach
    protected void createParameterBinderRegistry() {
        this.parameterBinderRegistry = new HSQLDBParameterBinderRegistry();
    }

    @BeforeEach
    protected void createJavaTypeToSqlTypeMapping() {
        this.javaTypeToSqlTypeMapping = new HSQLDBTypeMapping();
    }

    @Test
    void zonedDateTimeBinder() throws SQLException {
        ZonedDateTime initialTime = ZonedDateTime.of(2024, 6, 18, 11, 22, 33, 123456789, ZoneOffset.ofHours(5));
        ZonedDateTime comparisonTime = ZonedDateTime.of(2024, 6, 18, 11, 22, 33, 123456000, ZoneOffset.ofHours(5));
        Set databaseContent = this.insertAndSelect(ZonedDateTime.class, Arrays.asSet((Object[])new ZonedDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new ZonedDateTime[]{null, comparisonTime}));
    }

    @Test
    void offsetDateTimeBinder() throws SQLException {
        OffsetDateTime initialTime = OffsetDateTime.of(2024, 6, 18, 11, 22, 33, 123456789, ZoneOffset.ofHours(5));
        OffsetDateTime comparisonTime = OffsetDateTime.of(2024, 6, 18, 11, 22, 33, 123456000, ZoneOffset.ofHours(5));
        Set databaseContent = this.insertAndSelect(OffsetDateTime.class, Arrays.asSet((Object[])new OffsetDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new OffsetDateTime[]{null, comparisonTime}));
    }
}

