/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.SelectablesPod;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public interface QueryStatement
extends SelectablesPod {
    default public PseudoTable asPseudoTable() {
        return this.asPseudoTable(null);
    }

    default public PseudoTable asPseudoTable(@Nullable String name) {
        return new PseudoTable(this, name);
    }

    public static class PseudoColumn<O>
    implements JoinLink<Fromable, O> {
        private final SelectablesPod owner;
        private final String name;
        private final Class<O> javaType;

        public PseudoColumn(SelectablesPod owner, String name, Class<O> javaType) {
            this.owner = owner;
            this.name = name;
            this.javaType = javaType;
        }

        @Override
        public Fromable getOwner() {
            return (Fromable)this.owner;
        }

        @Override
        public String getExpression() {
            return this.name;
        }

        @Override
        public Class<O> getJavaType() {
            return this.javaType;
        }
    }

    public static class PseudoTable
    implements Fromable {
        @Nullable
        private final String name;
        private final QueryStatement queryStatement;
        private final KeepOrderSet<PseudoColumn<Object>> columns = new KeepOrderSet();
        private final Map<Selectable<?>, String> aliases = new HashMap();

        public PseudoTable(QueryStatement queryStatement, @Nullable String name) {
            this.name = name;
            this.queryStatement = queryStatement;
            Map<Selectable<?>, String> unionAliases = queryStatement.getAliases();
            for (Selectable<?> column : queryStatement.getColumns()) {
                PseudoColumn newPseudoColumn = new PseudoColumn(this, column.getExpression(), column.getJavaType());
                this.columns.add(newPseudoColumn);
                String alias = unionAliases.get(column);
                if (alias == null) continue;
                this.aliases.put(newPseudoColumn, alias);
            }
        }

        public QueryStatement getQueryStatement() {
            return this.queryStatement;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public String getAbsoluteName() {
            return this.getName();
        }

        public Set<PseudoColumn<?>> getColumns() {
            return this.columns;
        }

        @Override
        public Map<Selectable<?>, String> getAliases() {
            return this.aliases;
        }

        public Map<String, PseudoColumn<?>> mapColumnsOnName() {
            return Iterables.map(this.getColumns(), objectPseudoColumn -> (String)Objects.preventNull((Object)this.aliases.get(objectPseudoColumn), (Object)objectPseudoColumn.getExpression()));
        }
    }
}

