/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.StaleStateObjectException;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.AbstractDMLExecutorMockTest;
import org.codefilarete.stalactite.engine.runtime.AbstractVersioningStrategy;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.engine.runtime.ExtendedMapAssert;
import org.codefilarete.stalactite.engine.runtime.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.VersionnedToto;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.TransactionAwareConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class UpdateExecutorTest<T extends Table<T>>
extends AbstractDMLExecutorMockTest {
    private final Dialect dialect = new DefaultDialect(new JavaTypeToSqlTypeMapping().with(Integer.class, "int"));
    private UpdateExecutor<DMLExecutorTest.Toto, Integer, T> testInstance;

    UpdateExecutorTest() {
    }

    @BeforeEach
    void setUp() {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = UpdateExecutorTest.giveDefaultPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        this.testInstance = new UpdateExecutor(persistenceConfiguration.entityMapping, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.jdbcMock.transactionManager, 3), dmlGenerator, this.noRowCountCheckWriteOperationFactory, 3);
    }

    @Test
    void updateById() throws Exception {
        this.testInstance.updateById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((String)((String)this.jdbcMock.sqlCaptor.getValue())).isEqualTo("update Toto set b = ?, c = ? where a = ?");
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().newRow(1, 17).add(2, 23).add(3, 1).newRow(1, 29).add(2, 31).add(3, 2).newRow(1, 37).add(2, 41).add(3, 3).newRow(1, 43).add(2, 53).add(3, 4);
        UpdateExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void update_mandatoryColumn() {
        Column bColumn = (Column)this.testInstance.getMapping().getTargetTable().mapColumnsOnName().get("b");
        bColumn.setNullable(Boolean.valueOf(false));
        List differencesIterable = Arrays.asList((Object[])new Duo[]{new Duo((Object)new DMLExecutorTest.Toto(1, null, 23), (Object)new DMLExecutorTest.Toto(1, 42, 23))});
        Iterable payloads = UpdateListener.computePayloads((Iterable)differencesIterable, (boolean)true, (Mapping)this.testInstance.getMapping());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testInstance.updateMappedColumns(payloads)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected non null value for column Toto.b on instance Toto{a=1, b=null, c=23}");
    }

    @Test
    void listenerIsCalled() {
        SQLOperation.SQLOperationListener listenerMock = (SQLOperation.SQLOperationListener)Mockito.mock(SQLOperation.SQLOperationListener.class);
        this.testInstance.setOperationListener(listenerMock);
        ArgumentCaptor statementArgCaptor = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor sqlArgCaptor = ArgumentCaptor.forClass(SQLStatement.class);
        try {
            this.testInstance.updateById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31)}));
        }
        catch (StaleStateObjectException staleStateObjectException) {
            // empty catch block
        }
        Table mappedTable = new Table("Toto");
        Column colA = mappedTable.addColumn("a", Integer.class);
        Column colB = mappedTable.addColumn("b", Integer.class);
        Column colC = mappedTable.addColumn("c", Integer.class);
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)2))).onValuesSet((Map)statementArgCaptor.capture());
        ExtendedMapAssert.assertThatMap((Map)statementArgCaptor.getAllValues().get(0)).usingElementPredicate((entry1, entry2) -> ((Mapping.UpwhereColumn)entry1.getKey()).getColumn().getAbsoluteName().equals(((Mapping.UpwhereColumn)entry2.getKey()).getColumn().getAbsoluteName()) && ((Mapping.UpwhereColumn)entry1.getKey()).isUpdate() == ((Mapping.UpwhereColumn)entry2.getKey()).isUpdate() && ((Integer)entry1.getValue()).equals(entry2.getValue())).containsExactlyInAnyOrder(new Map.Entry[]{Assertions.entry((Object)new Mapping.UpwhereColumn(colA, false), (Object)1), Assertions.entry((Object)new Mapping.UpwhereColumn(colB, true), (Object)17), Assertions.entry((Object)new Mapping.UpwhereColumn(colC, true), (Object)23)});
        ExtendedMapAssert.assertThatMap((Map)statementArgCaptor.getAllValues().get(1)).usingElementPredicate((entry1, entry2) -> ((Mapping.UpwhereColumn)entry1.getKey()).getColumn().getAbsoluteName().equals(((Mapping.UpwhereColumn)entry2.getKey()).getColumn().getAbsoluteName()) && ((Mapping.UpwhereColumn)entry1.getKey()).isUpdate() == ((Mapping.UpwhereColumn)entry2.getKey()).isUpdate() && ((Integer)entry1.getValue()).equals(entry2.getValue())).containsExactlyInAnyOrder(new Map.Entry[]{Assertions.entry((Object)new Mapping.UpwhereColumn(colA, false), (Object)2), Assertions.entry((Object)new Mapping.UpwhereColumn(colB, true), (Object)29), Assertions.entry((Object)new Mapping.UpwhereColumn(colC, true), (Object)31)});
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)1))).onExecute((SQLStatement)sqlArgCaptor.capture());
        Assertions.assertThat((String)((SQLStatement)sqlArgCaptor.getValue()).getSQL()).isEqualTo("update Toto set b = ?, c = ? where a = ?");
    }

    @Test
    void updateById_noColumnToUpdate() {
        Table table = new Table("SimpleEntity");
        Column id = table.addColumn("id", Long.TYPE).primaryKey();
        AccessorByField idAccessor = Accessors.accessorByField(SimpleEntity.class, (String)"id");
        Maps.ChainingHashMap mapping = Maps.forHashMap((Class)null, (Class)null).add((Object)idAccessor, (Object)id);
        DefaultEntityMapping simpleEntityPersistenceMapping = new DefaultEntityMapping(SimpleEntity.class, table, (Map)mapping, (ReversibleAccessor)idAccessor, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.TYPE, c -> {}, c -> true));
        UpdateExecutor testInstance = new UpdateExecutor((EntityMapping)simpleEntityPersistenceMapping, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class), 4), new DMLGenerator((ParameterBinderIndex)new ColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, DMLNameProvider::new), new WriteOperationFactory(), 4);
        Assertions.assertThatCode(() -> testInstance.updateById((Iterable)Arrays.asList((Object[])new SimpleEntity[]{new SimpleEntity()}))).doesNotThrowAnyException();
    }

    public static Object[][] testUpdate_diff_data() {
        return new Object[][]{{Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 1, 1), new DMLExecutorTest.Toto(2, 2, 2)}), Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 1, 1), new DMLExecutorTest.Toto(2, 2, 2)}), new ExpectedResult_TestUpdate_diff(0, 0, 0, Collections.EMPTY_LIST, new PairSetList<Integer, Integer>())}, {Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 1, 1), new DMLExecutorTest.Toto(2, 2, 2), new DMLExecutorTest.Toto(3, 3, 3)}), Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 2, 1), new DMLExecutorTest.Toto(2, 3, 2), new DMLExecutorTest.Toto(3, 4, 3)}), new ExpectedResult_TestUpdate_diff(3, 1, 6, Arrays.asList((Object[])new String[]{"update Toto set b = ? where a = ?"}), new PairSetList<Integer, Integer>().newRow(1, 2).add(2, 1).add(1, 3).add(2, 2).add(1, 4).add(2, 3))}, {Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 1, 1), new DMLExecutorTest.Toto(2, 2, 2), new DMLExecutorTest.Toto(3, 3, 3), new DMLExecutorTest.Toto(4, 4, 4)}), Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 2, 1), new DMLExecutorTest.Toto(2, 3, 2), new DMLExecutorTest.Toto(3, 4, 3), new DMLExecutorTest.Toto(4, 5, 4)}), new ExpectedResult_TestUpdate_diff(4, 2, 8, Arrays.asList((Object[])new String[]{"update Toto set b = ? where a = ?"}), new PairSetList<Integer, Integer>().newRow(1, 2).add(2, 1).add(1, 3).add(2, 2).add(1, 4).add(2, 3).add(1, 5).add(2, 4))}, {Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 1, 1), new DMLExecutorTest.Toto(2, 2, 2), new DMLExecutorTest.Toto(3, 3, 3), new DMLExecutorTest.Toto(4, 4, 4)}), Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 11, 11), new DMLExecutorTest.Toto(2, 22, 22), new DMLExecutorTest.Toto(3, 33, 33), new DMLExecutorTest.Toto(4, 44, 44)}), new ExpectedResult_TestUpdate_diff(4, 2, 12, Arrays.asList((Object[])new String[]{"update Toto set b = ?, c = ? where a = ?"}), new PairSetList<Integer, Integer>().newRow(1, 11).add(2, 11).add(3, 1).add(1, 22).add(2, 22).add(3, 2).add(1, 33).add(2, 33).add(3, 3).add(1, 44).add(2, 44).add(3, 4))}, {Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 1, 1), new DMLExecutorTest.Toto(2, 2, 2), new DMLExecutorTest.Toto(3, 3, 3), new DMLExecutorTest.Toto(4, 4, 4), new DMLExecutorTest.Toto(5, 5, 5), new DMLExecutorTest.Toto(6, 6, 6), new DMLExecutorTest.Toto(7, 7, 7)}), Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 11, 1), new DMLExecutorTest.Toto(2, 22, 2), new DMLExecutorTest.Toto(3, 33, 3), new DMLExecutorTest.Toto(4, 44, 444), new DMLExecutorTest.Toto(5, 55, 555), new DMLExecutorTest.Toto(6, 66, 666), new DMLExecutorTest.Toto(7, 7, 7)}), new ExpectedResult_TestUpdate_diff(6, 2, 15, Arrays.asList((Object[])new String[]{"update Toto set b = ? where a = ?", "update Toto set b = ?, c = ? where a = ?"}), new PairSetList<Integer, Integer>().newRow(1, 11).add(2, 1).add(1, 22).add(2, 2).add(1, 33).add(2, 3).add(1, 44).add(2, 444).add(3, 4).add(1, 55).add(2, 555).add(3, 5).add(1, 66).add(2, 666).add(3, 6))}};
    }

    @ParameterizedTest
    @MethodSource(value={"testUpdate_diff_data"})
    void update_diff(List<DMLExecutorTest.Toto> originalInstances, List<DMLExecutorTest.Toto> modifiedInstances, ExpectedResult_TestUpdate_diff expectedResult) throws Exception {
        Iterable duos = () -> new PairIterator((Iterable)modifiedInstances, (Iterable)originalInstances);
        this.testInstance.updateVariousColumns(UpdateListener.computePayloads(duos, (boolean)false, (Mapping)this.testInstance.getMapping()));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)expectedResult.addBatchCallCount))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)expectedResult.executeBatchCallCount))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)expectedResult.setIntCallCount))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)expectedResult.updateStatements);
        UpdateExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedResult.statementValues);
    }

    @Test
    void update_diff_allColumns() throws Exception {
        List originalInstances = Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53), new DMLExecutorTest.Toto(5, -1, -2)});
        List modifiedInstances = Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 123), new DMLExecutorTest.Toto(2, 129, 31), new DMLExecutorTest.Toto(3, 137, 141), new DMLExecutorTest.Toto(4, 143, 153), new DMLExecutorTest.Toto(5, -1, -2)});
        UpdateExecutor<DMLExecutorTest.Toto, Integer, T> localTestInstance = this.testInstance;
        localTestInstance.updateMappedColumns(UpdateListener.computePayloads(() -> new PairIterator((Iterable)modifiedInstances, (Iterable)originalInstances), (boolean)true, (Mapping)localTestInstance.getMapping()));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"update Toto set b = ?, c = ? where a = ?"}));
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().newRow(1, 17).add(2, 123).add(3, 1).newRow(1, 129).add(2, 31).add(3, 2).newRow(1, 137).add(2, 141).add(3, 3).newRow(1, 143).add(2, 153).add(3, 4);
        UpdateExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    <T extends Table<T>> void update_noColumnToUpdate() {
        Table table = new Table("SimpleEntity");
        Column id = table.addColumn("id", Long.TYPE).primaryKey();
        AccessorByField idAccessor = Accessors.accessorByField(SimpleEntity.class, (String)"id");
        DefaultEntityMapping simpleEntityPersistenceMapping = new DefaultEntityMapping(SimpleEntity.class, table, (Map)Maps.asMap((Object)idAccessor, (Object)id), (ReversibleAccessor)idAccessor, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.TYPE, c -> {}, c -> false));
        UpdateExecutor testInstance = new UpdateExecutor((EntityMapping)simpleEntityPersistenceMapping, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class), 4), new DMLGenerator((ParameterBinderIndex)new ColumnBinderRegistry(), (Sorter)DMLGenerator.NoopSorter.INSTANCE, DMLNameProvider::new), new WriteOperationFactory(), 4);
        Iterable updatePayloads = UpdateListener.computePayloads((Iterable)Arrays.asList((Object[])new Duo[]{new Duo((Object)new SimpleEntity(), (Object)new SimpleEntity())}), (boolean)true, (Mapping)testInstance.getMapping());
        Assertions.assertThatCode(() -> testInstance.updateMappedColumns(updatePayloads)).doesNotThrowAnyException();
    }

    @Test
    void update_withVersioningStrategy() throws SQLException {
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatement.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.prepareStatement(Mockito.anyString())).thenReturn((Object)preparedStatement);
        Mockito.when((Object)connection.prepareStatement(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)preparedStatement);
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connection);
        TransactionAwareConnectionProvider connectionProvider = new TransactionAwareConnectionProvider(connectionProviderMock);
        Table totoTable = new Table("toto");
        Column pk = totoTable.addColumn("id", Integer.class).primaryKey();
        Column modifiedColumn = totoTable.addColumn("c", Integer.class);
        Column versionColumn = totoTable.addColumn("version", Long.class);
        PropertyAccessor identifierAccessor = PropertyAccessor.fromMethodReference(VersionnedToto::getA, VersionnedToto::setA);
        Maps.ChainingHashMap mapping = Maps.forHashMap((Class)null, (Class)null).add((Object)PropertyAccessor.fromMethodReference(VersionnedToto::getVersion, VersionnedToto::setVersion), (Object)versionColumn).add((Object)Accessors.accessorByField(VersionnedToto.class, (String)"c"), (Object)modifiedColumn).add((Object)identifierAccessor, (Object)pk);
        PropertyAccessor versioningAttributeAccessor = PropertyAccessor.fromMethodReference(VersionnedToto::getVersion, VersionnedToto::setVersion);
        SimpleIdMapping idMapping = new SimpleIdMapping((ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Integer.class, c -> {}, c -> false), new SingleIdentifierAssembler(pk));
        UpdateExecutor testInstance = new UpdateExecutor((EntityMapping)new DefaultEntityMapping(VersionnedToto.class, totoTable, (Map)mapping, Collections.emptyMap(), new Duo((Object)versioningAttributeAccessor, (Object)versionColumn), (IdMapping)idMapping, null, false), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)connectionProvider, 3), dmlGenerator, new WriteOperationFactory(), 3);
        testInstance.setVersioningStrategy((VersioningStrategy)new AbstractVersioningStrategy.VersioningStrategySupport((ReversibleAccessor)versioningAttributeAccessor, input -> {
            input = input + 1L;
            return input;
        }));
        VersionnedToto toto1 = new VersionnedToto(42, 17, 23);
        VersionnedToto toto2 = new VersionnedToto(42, 17, 24);
        testInstance.update((Iterable)Arrays.asList((Object[])new Duo[]{new Duo((Object)toto2, (Object)toto1)}), true);
        Assertions.assertThat((long)toto2.getVersion()).isEqualTo(1L);
        testInstance.getConnectionProvider().giveConnection().rollback();
        Assertions.assertThat((long)toto2.getVersion()).isEqualTo(0L);
        testInstance.getConnectionProvider().giveConnection().rollback();
        Assertions.assertThat((long)toto2.getVersion()).isEqualTo(0L);
    }

    private static class SimpleEntity {
        private long id;

        private SimpleEntity() {
        }
    }

    private static class ExpectedResult_TestUpdate_diff {
        private final int addBatchCallCount;
        private final int executeBatchCallCount;
        private final int setIntCallCount;
        private final List<String> updateStatements;
        private final PairSetList<Integer, Integer> statementValues;

        public ExpectedResult_TestUpdate_diff(int addBatchCallCount, int executeBatchCallCount, int setIntCallCount, List<String> updateStatements, PairSetList<Integer, Integer> statementValues) {
            this.addBatchCallCount = addBatchCallCount;
            this.executeBatchCallCount = executeBatchCallCount;
            this.setIntCallCount = setIntCallCount;
            this.updateStatements = updateStatements;
            this.statementValues = statementValues;
        }
    }
}

