/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.SimpleBeanCache;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Test;

class SimpleBeanCacheTest {
    SimpleBeanCacheTest() {
    }

    @Test
    void testComputeIfAbsent() {
        SimpleBeanCache testInstance = new SimpleBeanCache();
        MutableInt factoryCallCounter = new MutableInt();
        Function<Integer, String> capturingFactory = key -> {
            factoryCallCounter.increment();
            return "hello " + key;
        };
        String s = (String)testInstance.computeIfAbsent(String.class, (Object)1, capturingFactory);
        Assertions.assertThat((String)s).isEqualTo("hello 1");
        s = (String)testInstance.computeIfAbsent(String.class, (Object)1, capturingFactory);
        Assertions.assertThat((String)s).isEqualTo("hello 1");
        Assertions.assertThat((int)factoryCallCounter.getValue()).isEqualTo(1);
        s = (String)testInstance.computeIfAbsent(String.class, (Object)2, capturingFactory);
        Assertions.assertThat((String)s).isEqualTo("hello 2");
        Assertions.assertThat((int)factoryCallCounter.getValue()).isEqualTo(2);
    }

    @Test
    void testComputeIfAbsent_ArrayAsKeySafety() {
        SimpleBeanCache testInstance = new SimpleBeanCache();
        MutableInt factoryCallCounter = new MutableInt();
        Function<Object[], String> capturingFactory = key -> {
            factoryCallCounter.increment();
            return "hello";
        };
        String s = (String)testInstance.computeIfAbsent(String.class, (Object)new Object[]{1, 2}, capturingFactory);
        Assertions.assertThat((String)s).isEqualTo("hello");
        s = (String)testInstance.computeIfAbsent(String.class, (Object)new Object[]{1, 2}, capturingFactory);
        Assertions.assertThat((String)s).isEqualTo("hello");
        Assertions.assertThat((int)factoryCallCounter.getValue()).isEqualTo(1);
    }
}

