/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.repository.query;

import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.spring.repository.query.AbstractQuery;
import org.codefilarete.tool.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteQuery<C, R>
implements RepositoryQuery {
    private final QueryMethod method;
    private final Query<C> query;
    private final Accumulator<C, ?, R> accumulator;

    public PartTreeStalactiteQuery(QueryMethod method, EntityPersister<C, ?> entityPersister, PartTree tree, Accumulator<C, ?, R> accumulator) {
        this.method = method;
        this.accumulator = accumulator;
        Parameters parameters = method.getParameters();
        boolean recreationRequired = parameters.potentiallySortsDynamically();
        try {
            this.query = new Query<C>(entityPersister, tree);
            if (tree.getSort().isSorted()) {
                tree.getSort().iterator().forEachRemaining(order -> {
                    PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                    AccessorChain orderProperty = this.query.convertToAccessorChain(propertyPath);
                    ((Query)this.query).executableEntityQuery.orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC);
                });
            }
            Nullable.nullable((Object)tree.getMaxResults()).invoke(arg_0 -> ((EntityPersister.ExecutableEntityQuery)((Query)this.query).executableEntityQuery).limit(arg_0));
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", method, o_O.getMessage()), o_O);
        }
    }

    @org.springframework.lang.Nullable
    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        Object result = ((Query)this.query).executableEntityQuery.execute(this.accumulator);
        if (this.method.getResultProcessor().getReturnedType().isProjecting() || this.method.getParameters().hasDynamicProjection()) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor).processResult(result);
        }
        return (R)result;
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    class Query<T>
    extends AbstractQuery<T> {
        private final EntityPersister.ExecutableEntityQuery<T> executableEntityQuery;

        Query(EntityPersister<T, ?> entityPersister, PartTree tree) {
            super(entityPersister);
            this.executableEntityQuery = entityPersister.selectWhere();
            tree.forEach(orPart -> orPart.forEach(this::append));
        }

        private void append(Part part) {
            AbstractQuery.Criterion criterion = this.convertToOperator(part.getType());
            this.executableEntityQuery.and(this.convertToAccessorChain(part.getProperty()), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

