/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterOutOfBoundsException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;

public class QueryMethodValidator {
    private final PartTree tree;
    private final QueryMethod method;

    public QueryMethodValidator(PartTree tree, QueryMethod method) {
        this.tree = tree;
        this.method = method;
    }

    public void validate() {
        int argCount = 0;
        Iterable parts = () -> this.tree.stream().flatMap(Streamable::stream).iterator();
        for (Part part : parts) {
            int numberOfArguments = part.getNumberOfArguments();
            for (int i = 0; i < numberOfArguments; ++i) {
                this.throwExceptionOnArgumentMismatch(part, argCount);
                ++argCount;
            }
        }
    }

    private void throwExceptionOnArgumentMismatch(Part part, int index) {
        Parameter parameter;
        Part.Type type = part.getType();
        String property = part.getProperty().toDotPath();
        try {
            parameter = this.method.getParameters().getBindableParameter(index);
        }
        catch (ParameterOutOfBoundsException e) {
            throw new IllegalStateException(String.format("Method %s expects at least %d arguments but only found %d. This leaves an operator of type %s for property %s unbound.", this.method.getName(), index + 1, index, type.name(), property));
        }
        if (this.expectsCollection(type) && !this.parameterIsCollectionLike(parameter)) {
            throw new IllegalStateException(this.wrongParameterTypeMessage(property, type, "Collection", parameter));
        }
        if (!this.expectsCollection(type) && !this.parameterIsScalarLike(parameter)) {
            throw new IllegalStateException(this.wrongParameterTypeMessage(property, type, "scalar", parameter));
        }
    }

    private String wrongParameterTypeMessage(String property, Part.Type operatorType, String expectedArgumentType, Parameter parameter) {
        return String.format("Operator %s on %s requires a %s argument, found %s in method %s.", operatorType.name(), property, expectedArgumentType, parameter.getType(), this.method.getName());
    }

    private boolean parameterIsCollectionLike(Parameter parameter) {
        return Iterable.class.isAssignableFrom(parameter.getType()) || parameter.getType().isArray();
    }

    private boolean parameterIsScalarLike(Parameter parameter) {
        return !Iterable.class.isAssignableFrom(parameter.getType());
    }

    private boolean expectsCollection(Part.Type type) {
        return type == Part.Type.IN || type == Part.Type.NOT_IN;
    }
}

