/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;

public interface PersistExecutor<C> {
    public void persist(Iterable<? extends C> var1);

    public static class DefaultPersistExecutor<C, I>
    implements PersistExecutor<C> {
        protected final EntityPersister<C, I> persister;

        public DefaultPersistExecutor(EntityPersister<C, I> persister) {
            this.persister = persister;
        }

        @Override
        public void persist(Iterable<? extends C> entities) {
            this.persist(entities, this.persister::isNew, this.persister, this.persister, this.persister, this.persister::getId);
        }

        protected void persist(Iterable<? extends C> entities, Predicate<C> isNewProvider, SelectExecutor<C, I> selector, UpdateExecutor<C> updater, InsertExecutor<C> inserter, Function<C, I> idProvider) {
            if (Iterables.isEmpty(entities)) {
                return;
            }
            ArrayList<C> toInsert = new ArrayList<C>(20);
            ArrayList<C> toUpdate = new ArrayList<C>(20);
            for (C c : entities) {
                if (isNewProvider.test(c)) {
                    toInsert.add(c);
                    continue;
                }
                toUpdate.add(c);
            }
            if (!toInsert.isEmpty()) {
                inserter.insert(toInsert);
            }
            if (!toUpdate.isEmpty()) {
                Map existingEntitiesPerId = Iterables.map(selector.select(Iterables.collect(toUpdate, idProvider, HashSet::new)), idProvider);
                Map modifiedEntitiesPerId = Iterables.map(toUpdate, idProvider);
                Map modifiedVSunmodified = Maps.innerJoin((Map)modifiedEntitiesPerId, (Map)existingEntitiesPerId);
                ArrayList updateArg = new ArrayList();
                modifiedVSunmodified.forEach((k, v) -> updateArg.add(new Duo(k, v)));
                updater.update(updateArg, true);
            }
        }
    }
}

