/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Set;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;

public interface EntityInflater<C, I> {
    public EntityMapping<C, I, ?> getEntityMapping();

    default public Class<C> getEntityType() {
        return this.getEntityMapping().getClassToPersist();
    }

    public I giveIdentifier(ColumnedRow var1);

    public RowTransformer<C> getRowTransformer();

    public Set<Selectable<?>> getSelectableColumns();

    public static class EntityMappingAdapter<C, I, T extends Table<T>>
    implements EntityInflater<C, I> {
        private final EntityMapping<C, I, T> delegate;

        public EntityMappingAdapter(EntityMapping<C, I, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public EntityMapping<C, I, ?> getEntityMapping() {
            return this.delegate;
        }

        @Override
        public I giveIdentifier(ColumnedRow row) {
            return (I)this.delegate.getIdMapping().getIdentifierAssembler().assemble(row);
        }

        @Override
        public RowTransformer<C> getRowTransformer() {
            return this.delegate.getRowTransformer();
        }

        @Override
        public Set<Selectable<?>> getSelectableColumns() {
            return this.delegate.getSelectableColumns();
        }
    }
}

