/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.idprovider;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.idprovider.IdentifierProvider;

public abstract class PooledIdentifierProvider<T>
implements IdentifierProvider<T> {
    private final BlockingQueue<T> queue;
    private final int threshold;
    private final Executor executor;
    private final Duration timeOut;

    public PooledIdentifierProvider(Collection<T> initialValues, int threshold, Executor executor, Duration timeOut) {
        this.queue = initialValues.stream().collect(Collectors.toCollection(LinkedBlockingQueue::new));
        this.threshold = threshold;
        this.executor = executor;
        this.timeOut = timeOut;
    }

    private T pop() {
        try {
            return this.queue.poll(this.timeOut.getSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public T giveNewIdentifier() {
        boolean refueling = this.ensureMinimalPool();
        T toReturn = this.pop();
        if (!refueling) {
            this.ensureMinimalPool();
        }
        return toReturn;
    }

    private boolean ensureMinimalPool() {
        if (this.queue.size() < this.threshold) {
            this.executor.execute(this::fillQueue);
            return true;
        }
        return false;
    }

    private void fillQueue() {
        this.queue.addAll(new ArrayList<T>(this.retrieveSomeValues()));
    }

    protected abstract Collection<T> retrieveSomeValues();
}

