/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.cycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.AbstractCycleLoader;
import org.codefilarete.stalactite.engine.runtime.cycle.CycleLoadRuntimeContext;
import org.codefilarete.stalactite.engine.runtime.cycle.EntityRelationStorage;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

class AbstractCycleLoaderTest {
    AbstractCycleLoaderTest() {
    }

    static Object[][] afterSelect_withSamePersisterAsTrigger_databaseIsATree_doesntFallIntoInfiniteLoop() {
        return new Object[][]{{Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)0).add((Object)"name", (Object)"Root").add((Object)"childId", (Object)1), Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)1).add((Object)"name", (Object)"Root.1").add((Object)"childId", (Object)2), Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)2).add((Object)"name", (Object)"Root.1.1").add((Object)"childId", (Object)3)})}, {Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)0).add((Object)"name", (Object)"Root").add((Object)"childId", (Object)1), Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)1).add((Object)"name", (Object)"Root.1").add((Object)"childId", (Object)2), Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)2).add((Object)"name", (Object)"Root.1.1").add((Object)"childId", (Object)3), Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)2).add((Object)"name", (Object)"Root.1.1").add((Object)"childId", (Object)0)})}};
    }

    @ParameterizedTest
    @MethodSource
    void afterSelect_withSamePersisterAsTrigger_databaseIsATree_doesntFallIntoInfiniteLoop(List<Map<String, Object>> pseudoDatabase) {
        EntityPersister persister = (EntityPersister)Mockito.mock(EntityPersister.class);
        Mockito.when((Object)persister.getId(ArgumentMatchers.any())).thenAnswer(invocation -> {
            String entity = (String)invocation.getArgument(0);
            Optional<Map> foundRow = pseudoDatabase.stream().filter(row -> row.get("name").equals(entity)).findFirst();
            if (foundRow.isPresent()) {
                return (Integer)foundRow.get().get("id");
            }
            throw new NoSuchElementException("No identifier found for entity " + entity);
        });
        ArrayList executionStack = new ArrayList();
        EntityPersister persisterWrapperWithBeforeAfterSelect = (EntityPersister)Mockito.mock(EntityPersister.class);
        AbstractCycleLoader<String, String, Integer> testInstance = new AbstractCycleLoader<String, String, Integer>(persisterWrapperWithBeforeAfterSelect){

            protected void applyRelationToSource(EntityRelationStorage<String, Integer> targetIdsPerSource, BeanRelationFixer<String, String> beanRelationFixer, Map<Integer, String> targetPerId) {
            }
        };
        Mockito.when((Object)persisterWrapperWithBeforeAfterSelect.getId(ArgumentMatchers.any())).thenAnswer(invocation -> (Integer)persister.getId(invocation.getArgument(0)));
        Mockito.when((Object)persisterWrapperWithBeforeAfterSelect.select(ArgumentMatchers.anyIterable())).thenAnswer(arg_0 -> AbstractCycleLoaderTest.lambda$afterSelect_withSamePersisterAsTrigger_databaseIsATree_doesntFallIntoInfiniteLoop$3((AbstractCycleLoader)testInstance, persister, arg_0));
        Mockito.when((Object)persister.select((Iterable)ArgumentMatchers.anySet())).thenAnswer(arg_0 -> AbstractCycleLoaderTest.lambda$afterSelect_withSamePersisterAsTrigger_databaseIsATree_doesntFallIntoInfiniteLoop$6(executionStack, (AbstractCycleLoader)testInstance, pseudoDatabase, arg_0));
        ((CycleLoadRuntimeContext)testInstance.currentRuntimeContext.get()).addRelationToInitialize("relation", (Object)"Root", (Object)1);
        persisterWrapperWithBeforeAfterSelect.select((Iterable)Arrays.asSet((Object[])new Integer[]{0}));
        Assertions.assertThat(executionStack).containsExactly((Object[])new Set[]{Arrays.asSet((Object[])new Integer[]{0}), Arrays.asSet((Object[])new Integer[]{1}), Arrays.asSet((Object[])new Integer[]{2}), Arrays.asSet((Object[])new Integer[]{3})});
        Assertions.assertThat((boolean)testInstance.currentlyLoadedEntityIdsInCycle.isPresent()).isFalse();
        Assertions.assertThat((boolean)testInstance.currentRuntimeContext.isPresent()).isFalse();
        Assertions.assertThat((boolean)testInstance.currentCycleCount.isPresent()).isFalse();
    }

    private static /* synthetic */ Set lambda$afterSelect_withSamePersisterAsTrigger_databaseIsATree_doesntFallIntoInfiniteLoop$6(List executionStack, AbstractCycleLoader testInstance, List pseudoDatabase, InvocationOnMock invocation) throws Throwable {
        Set idsToSelect = (Set)invocation.getArgument(0);
        executionStack.add(idsToSelect);
        CycleLoadRuntimeContext cycleLoadRuntimeContext = (CycleLoadRuntimeContext)testInstance.currentRuntimeContext.get();
        Set<Map> matchingRows = pseudoDatabase.stream().filter(row -> idsToSelect.contains(row.get("id"))).collect(Collectors.toSet());
        HashSet result = new HashSet();
        matchingRows.forEach(row -> {
            String name = (String)row.get("name");
            cycleLoadRuntimeContext.addRelationToInitialize("relation", (Object)name, (Object)((Integer)row.get("childId")));
            result.add(name);
        });
        return result;
    }

    private static /* synthetic */ Object lambda$afterSelect_withSamePersisterAsTrigger_databaseIsATree_doesntFallIntoInfiniteLoop$3(AbstractCycleLoader testInstance, EntityPersister persister, InvocationOnMock invocation) throws Throwable {
        testInstance.beforeSelect((Iterable)invocation.getArgument(0));
        Collection idsToSelect = (Collection)invocation.getArgument(0);
        Set result = persister.select((Iterable)idsToSelect);
        testInstance.afterSelect(result);
        return result;
    }
}

