/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.dsl.naming;

import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class IndexNamingStrategyTest {
    IndexNamingStrategyTest() {
    }

    static Iterable<Arguments> defaultImplementation_data() {
        EmbeddableMappingConfiguration.Linkage abstractVehicleTimestamp = (EmbeddableMappingConfiguration.Linkage)Mockito.mock(EmbeddableMappingConfiguration.Linkage.class);
        Mockito.when((Object)abstractVehicleTimestamp.getAccessor()).thenReturn((Object)PropertyAccessor.fromMethodReference(AbstractVehicle::getTimestamp, AbstractVehicle::setTimestamp));
        EmbeddableMappingConfiguration.Linkage personMainBicycle = (EmbeddableMappingConfiguration.Linkage)Mockito.mock(EmbeddableMappingConfiguration.Linkage.class);
        Mockito.when((Object)personMainBicycle.getAccessor()).thenReturn((Object)PropertyAccessor.fromMethodReference(Person::getMainBicycle, Person::setMainBicycle));
        EmbeddableMappingConfiguration.Linkage personMainBicycle_withOverriddenName = (EmbeddableMappingConfiguration.Linkage)Mockito.mock(EmbeddableMappingConfiguration.Linkage.class);
        Mockito.when((Object)personMainBicycle_withOverriddenName.getAccessor()).thenReturn((Object)PropertyAccessor.fromMethodReference(Person::getMainBicycle, Person::setMainBicycle));
        Mockito.when((Object)personMainBicycle_withOverriddenName.getColumnName()).thenReturn((Object)"principalBike");
        return Arrays.asList((Object[])new Arguments[]{Arguments.arguments((Object[])new Object[]{abstractVehicleTimestamp, "abstract_vehicle_timestamp_key"}), Arguments.arguments((Object[])new Object[]{personMainBicycle, "person_main_bicycle_key"}), Arguments.arguments((Object[])new Object[]{personMainBicycle_withOverriddenName, "person_principal_bike_key"})});
    }

    @ParameterizedTest
    @MethodSource(value={"defaultImplementation_data"})
    void defaultImplementation(EmbeddableMappingConfiguration.Linkage linkage, String expectedIndexName) {
        String indexName = IndexNamingStrategy.DEFAULT.giveName(linkage);
        Assertions.assertThat((String)indexName).isEqualTo(expectedIndexName);
    }
}

