/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.MapEntryTableNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteCollectionCascader;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.map.ConvertingMapAccessor;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.map.MapEntryKeyAndValueEntitiesUpdater;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.map.MapRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.Functions;

public class EntityAsKeyAndValueMapRelationConfigurer<SRC, SRCID, K, KID, V, VID, M extends Map<K, V>, MM extends Map<KID, VID>>
extends MapRelationConfigurer<SRC, SRCID, KID, VID, MM> {
    private final MapRelation<SRC, K, V, M> originalMapRelation;
    private final ConfiguredRelationalPersister<K, KID> keyEntityPersister;
    private final ConfiguredRelationalPersister<V, VID> valueEntityPersister;
    private final Function<SRC, M> mapGetter;
    private final InMemoryRelationHolder<SRCID, KID, VID, K, V> inMemoryRelationHolder;
    private Key<?, KID> keyIdColumnsProjectInAssociationTable;
    private Key<?, VID> valueIdColumnsProjectInAssociationTable;
    private final CascadeOptions.RelationMode keyEntityMaintenanceMode;
    private final CascadeOptions.RelationMode valueEntityMaintenanceMode;
    private final boolean associationRecordWritable;

    private static <SRC, K, KID, V, VID, M extends Map<K, V>, MM extends Map<KID, VID>> MapRelation<SRC, KID, VID, MM> convertEntityMapToIdentifierMap(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<K, KID> keyEntityPersister, ConfiguredRelationalPersister<V, VID> valueEntityPersister) {
        ConvertingMapAccessor mapAccessor = new ConvertingMapAccessor(mapRelation, (k, v, result) -> result.put(keyEntityPersister.getId(k), valueEntityPersister.getId(v)));
        PropertyAccessor propertyAccessor = new PropertyAccessor(mapAccessor, (src, mm) -> {});
        MapRelation result2 = new MapRelation(propertyAccessor, keyEntityPersister.getMapping().getIdMapping().getIdentifierInsertionManager().getIdentifierType(), valueEntityPersister.getMapping().getIdMapping().getIdentifierInsertionManager().getIdentifierType());
        result2.setTargetTable(mapRelation.getTargetTable());
        result2.setTargetTableName(mapRelation.getTargetTableName());
        result2.setMapFactory(mapRelation.getMapFactory());
        result2.setKeyEntityRelationMode(mapRelation.getKeyEntityRelationMode());
        result2.setValueEntityRelationMode(mapRelation.getValueEntityRelationMode());
        return result2;
    }

    public EntityAsKeyAndValueMapRelationConfigurer(MapRelation<SRC, K, V, M> mapRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, ConfiguredRelationalPersister<K, KID> keyEntityPersister, ConfiguredRelationalPersister<V, VID> valueEntityPersister, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy columnNamingStrategy, MapEntryTableNamingStrategy tableNamingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration, IndexNamingStrategy indexNamingStrategy) {
        super(EntityAsKeyAndValueMapRelationConfigurer.convertEntityMapToIdentifierMap(mapRelation, keyEntityPersister, valueEntityPersister), sourcePersister, foreignKeyNamingStrategy, columnNamingStrategy, tableNamingStrategy, dialect, connectionConfiguration, indexNamingStrategy);
        this.originalMapRelation = mapRelation;
        this.keyEntityPersister = keyEntityPersister;
        this.valueEntityPersister = valueEntityPersister;
        this.mapGetter = arg_0 -> this.originalMapRelation.getMapProvider().get(arg_0);
        this.inMemoryRelationHolder = new InMemoryRelationHolder();
        this.keyEntityMaintenanceMode = mapRelation.getKeyEntityRelationMode();
        this.valueEntityMaintenanceMode = mapRelation.getValueEntityRelationMode();
        this.associationRecordWritable = this.keyEntityMaintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
    }

    @Override
    public void configure() {
        AccessorDefinition mapProviderDefinition = AccessorDefinition.giveDefinition(this.originalMapRelation.getMapProvider());
        final Supplier mapFactory = Reflections.giveMapFactory((Class)mapProviderDefinition.getMemberType());
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>(){

            public void beforeSelect(Iterable<SRCID> ids) {
                EntityAsKeyAndValueMapRelationConfigurer.this.inMemoryRelationHolder.init();
            }

            public void afterSelect(Set<? extends SRC> result) {
                BeanRelationFixer originalRelationFixer = BeanRelationFixer.ofMapAdapter((arg_0, arg_1) -> ((Mutator)EntityAsKeyAndValueMapRelationConfigurer.this.originalMapRelation.getMapProvider().toMutator()).set(arg_0, arg_1), (Function)EntityAsKeyAndValueMapRelationConfigurer.this.mapGetter, (Supplier)mapFactory, (bean, duo, map) -> map.put(duo.getLeft(), duo.getRight()));
                result.forEach(bean -> {
                    Collection keyValuePairs = EntityAsKeyAndValueMapRelationConfigurer.this.inMemoryRelationHolder.get(EntityAsKeyAndValueMapRelationConfigurer.this.sourcePersister.getId(bean));
                    if (keyValuePairs != null) {
                        keyValuePairs.forEach(duo -> originalRelationFixer.apply(bean, duo));
                    }
                });
                EntityAsKeyAndValueMapRelationConfigurer.this.inMemoryRelationHolder.clear();
            }
        });
        super.configure();
    }

    @Override
    <SRCTABLE extends Table<SRCTABLE>, MAPTABLE extends Table<MAPTABLE>> DefaultEntityMapping<KeyValueRecord<KID, VID, SRCID>, RecordId<KID, SRCID>, MAPTABLE> buildKeyValueRecordMapping(final MAPTABLE targetTable, IdentifierAssembler<SRCID, SRCTABLE> sourceIdentifierAssembler, Map<Column<SRCTABLE, ?>, Column<MAPTABLE, ?>> srcPrimaryKeyToForeignKeyColumns, EmbeddableMappingConfiguration<KID> keyEmbeddableConfiguration, EmbeddableMappingConfiguration<VID> valueEmbeddableConfiguration) {
        KeyValueRecordMappingBuilder builder = new KeyValueRecordMappingBuilder<KID, VID, SRCID, MAPTABLE, SRCTABLE>(targetTable, sourceIdentifierAssembler, srcPrimaryKeyToForeignKeyColumns){
            private final Map<Column<MAPTABLE, Object>, Column<Table, Object>> mapEntryKeyForeignKeyBootstrap;
            private final Map<Column<MAPTABLE, Object>, Column<Table, Object>> mapEntryValueForeignKeyBootstrap;
            {
                super(associationTable, sourceIdentifierAssembler, primaryKeyForeignColumnMapping);
                this.mapEntryKeyForeignKeyBootstrap = new HashMap();
                this.mapEntryValueForeignKeyBootstrap = new HashMap();
            }

            @Override
            void withEntryKeyIsSingleProperty(Column<MAPTABLE, KID> keyColumn) {
                super.withEntryKeyIsSingleProperty(keyColumn);
                Column column = ((SimpleIdMapping)EntityAsKeyAndValueMapRelationConfigurer.this.keyEntityPersister.getMapping().getIdMapping()).getIdentifierAssembler().getColumn();
                this.mapEntryKeyForeignKeyBootstrap.put(keyColumn, (Column<Table, Object>)column);
                EntityAsKeyAndValueMapRelationConfigurer.this.keyIdColumnsProjectInAssociationTable = Key.ofSingleColumn(keyColumn);
            }

            @Override
            void withEntryKeyIsComplexType(EmbeddedClassMapping<KID, MAPTABLE> entryKeyMapping) {
                super.withEntryKeyIsComplexType(entryKeyMapping);
                Key.KeyBuilder keyIdColumnsProjectInAssociationTableBuilder = Key.from((Fromable)targetTable);
                entryKeyMapping.getPropertyToColumn().values().forEach(arg_0 -> ((Key.KeyBuilder)keyIdColumnsProjectInAssociationTableBuilder).addColumn(arg_0));
                EntityAsKeyAndValueMapRelationConfigurer.this.keyIdColumnsProjectInAssociationTable = keyIdColumnsProjectInAssociationTableBuilder.build();
            }

            @Override
            void withEntryValueIsSingleProperty(Column<MAPTABLE, VID> valueColumn) {
                super.withEntryValueIsSingleProperty(valueColumn);
                Column column = ((SimpleIdMapping)EntityAsKeyAndValueMapRelationConfigurer.this.valueEntityPersister.getMapping().getIdMapping()).getIdentifierAssembler().getColumn();
                this.mapEntryValueForeignKeyBootstrap.put(valueColumn, (Column<Table, Object>)column);
                EntityAsKeyAndValueMapRelationConfigurer.this.valueIdColumnsProjectInAssociationTable = Key.ofSingleColumn(valueColumn);
            }

            @Override
            void withEntryValueIsComplexType(EmbeddedClassMapping<VID, MAPTABLE> entryValueMapping) {
                super.withEntryValueIsComplexType(entryValueMapping);
                Key.KeyBuilder keyIdColumnsProjectInAssociationTableBuilder = Key.from((Fromable)targetTable);
                entryValueMapping.getPropertyToColumn().values().forEach(arg_0 -> ((Key.KeyBuilder)keyIdColumnsProjectInAssociationTableBuilder).addColumn(arg_0));
                EntityAsKeyAndValueMapRelationConfigurer.this.valueIdColumnsProjectInAssociationTable = keyIdColumnsProjectInAssociationTableBuilder.build();
            }

            @Override
            KeyValueRecordMapping<KID, VID, SRCID, MAPTABLE> build() {
                Key.KeyBuilder entryKeyKeyBuilder = Key.from((Fromable)targetTable);
                Key.KeyBuilder entryKeyReferencedKeyBuilder = Key.from(EntityAsKeyAndValueMapRelationConfigurer.this.keyEntityPersister.getMainTable());
                this.mapEntryKeyForeignKeyBootstrap.forEach((key, value) -> {
                    entryKeyKeyBuilder.addColumn((JoinLink)key);
                    entryKeyReferencedKeyBuilder.addColumn((JoinLink)value);
                });
                Key.KeyBuilder entryValueKeyBuilder = Key.from((Fromable)targetTable);
                Key.KeyBuilder entryValueReferencedKeyBuilder = Key.from(EntityAsKeyAndValueMapRelationConfigurer.this.valueEntityPersister.getMainTable());
                this.mapEntryValueForeignKeyBootstrap.forEach((key, value) -> {
                    entryValueKeyBuilder.addColumn((JoinLink)key);
                    entryValueReferencedKeyBuilder.addColumn((JoinLink)value);
                });
                targetTable.addForeignKey(EntityAsKeyAndValueMapRelationConfigurer.this.foreignKeyNamingStrategy::giveName, entryKeyKeyBuilder.build(), entryKeyReferencedKeyBuilder.build());
                targetTable.addForeignKey(EntityAsKeyAndValueMapRelationConfigurer.this.foreignKeyNamingStrategy::giveName, entryValueKeyBuilder.build(), entryValueReferencedKeyBuilder.build());
                return super.build();
            }
        };
        return super.buildKeyValueRecordMapping(keyEmbeddableConfiguration, targetTable, builder, valueEmbeddableConfiguration);
    }

    @Override
    protected void addInsertCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<KID, VID, SRCID>, RecordId<KID, SRCID>> relationRecordPersister, Accessor<SRC, MM> mapAccessor) {
        if (this.keyEntityMaintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            sourcePersister.addInsertListener(new BeforeInsertCollectionCascader<SRC, K>(this.keyEntityPersister){

                @Override
                protected Collection<K> getTargets(SRC src) {
                    return ((Map)EntityAsKeyAndValueMapRelationConfigurer.this.mapGetter.apply(src)).keySet();
                }
            });
        }
        if (this.valueEntityMaintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            sourcePersister.addInsertListener(new BeforeInsertCollectionCascader<SRC, V>(this.valueEntityPersister){

                @Override
                protected Collection<V> getTargets(SRC src) {
                    return ((Map)EntityAsKeyAndValueMapRelationConfigurer.this.mapGetter.apply(src)).values();
                }
            });
        }
        if (this.associationRecordWritable) {
            Function mapProviderForInsert = this.toRecordCollectionProvider(sourcePersister.getMapping(), false);
            sourcePersister.addInsertListener(new MapRelationConfigurer.TargetInstancesInsertCascader(relationRecordPersister, mapProviderForInsert));
        }
    }

    @Override
    protected void addUpdateCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<KID, VID, SRCID>, RecordId<KID, SRCID>> relationRecordPersister) {
        Function<Object, Set> targetEntitiesGetter = src -> {
            Object srcId = sourcePersister.getId(src);
            Map map = (Map)this.mapGetter.apply(src);
            return map == null ? Collections.emptySet() : map.entrySet().stream().map(entry -> new KeyValueRecord(srcId, entry.getKey(), entry.getValue())).collect(Collectors.toSet());
        };
        MapEntryKeyAndValueEntitiesUpdater<Object, SRCID, Object, Object, Object, Object> mapUpdater = new MapEntryKeyAndValueEntitiesUpdater<Object, SRCID, Object, Object, Object, Object>(targetEntitiesGetter, arg_0 -> this.keyEntityPersister.getId(arg_0), arg_0 -> this.valueEntityPersister.getId(arg_0), this.keyEntityPersister, this.valueEntityPersister, relationRecordPersister, this.keyEntityMaintenanceMode, this.valueEntityMaintenanceMode);
        sourcePersister.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(mapUpdater));
    }

    @Override
    protected void addDeleteCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, EntityPersister<KeyValueRecord<KID, VID, SRCID>, RecordId<KID, SRCID>> relationRecordPersister) {
        Functions.NullProofFunction targetEntitiesGetter;
        if (this.associationRecordWritable) {
            super.addDeleteCascade(sourcePersister, relationRecordPersister);
        }
        if (this.keyEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            targetEntitiesGetter = new Functions.NullProofFunction(this.mapGetter).andThen(Map::entrySet).andThen(entries -> entries.stream().map(Map.Entry::getKey).collect(Collectors.toSet()));
            sourcePersister.addDeleteListener(new BeforeDeleteCollectionCascader<SRC, K>(this.keyEntityPersister, (Function)targetEntitiesGetter){
                final /* synthetic */ Function val$targetEntitiesGetter;
                {
                    this.val$targetEntitiesGetter = function;
                    super(persister);
                }

                @Override
                protected Collection<K> getTargets(SRC src) {
                    return (Collection)this.val$targetEntitiesGetter.apply(src);
                }
            });
        }
        if (this.valueEntityMaintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            targetEntitiesGetter = new Functions.NullProofFunction(this.mapGetter).andThen(Map::entrySet).andThen(entries -> entries.stream().map(Map.Entry::getValue).collect(Collectors.toSet()));
            sourcePersister.addDeleteListener(new BeforeDeleteCollectionCascader<SRC, V>(this.valueEntityPersister, (Function)targetEntitiesGetter){
                final /* synthetic */ Function val$targetEntitiesGetter;
                {
                    this.val$targetEntitiesGetter = function;
                    super(persister);
                }

                @Override
                protected Collection<V> getTargets(SRC src) {
                    return (Collection)this.val$targetEntitiesGetter.apply(src);
                }
            });
        }
    }

    @Override
    protected void addSelectCascade(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, SimpleRelationalEntityPersister<KeyValueRecord<KID, VID, SRCID>, RecordId<KID, SRCID>, ?> relationRecordPersister, PrimaryKey<?, SRCID> sourcePK, ForeignKey<?, ?, SRCID> keyValueRecordToSourceForeignKey, BiConsumer<SRC, MM> mapSetter, Accessor<SRC, MM> mapGetter, Supplier<MM> mapFactory) {
        BeanRelationFixer relationFixer = BeanRelationFixer.ofMapAdapter(mapSetter, arg_0 -> mapGetter.get(arg_0), mapFactory, (bean, input, map) -> this.inMemoryRelationHolder.storeRelation(input.getId().getId(), input.getKey(), input.getValue()));
        this.keyEntityPersister.joinAsMany("ROOT", relationRecordPersister, (Accessor)Accessors.accessorByMethodReference(KeyValueRecord::getKey), this.keyIdColumnsProjectInAssociationTable, (Key)this.keyEntityPersister.getMainTable().getPrimaryKey(), (bean, input) -> this.inMemoryRelationHolder.storeKeyEntity(bean.getId().getId(), bean.getKey(), input), null, true, false);
        this.valueEntityPersister.joinAsMany("ROOT", relationRecordPersister, (Accessor)Accessors.accessorByMethodReference(KeyValueRecord::getValue), this.valueIdColumnsProjectInAssociationTable, (Key)this.valueEntityPersister.getMainTable().getPrimaryKey(), (bean, input) -> this.inMemoryRelationHolder.storeValueEntity(bean.getId().getId(), bean.getValue(), input), null, true, false);
        relationRecordPersister.joinAsMany("ROOT", sourcePersister, (Accessor)mapGetter, (Key)sourcePK, (Key)keyValueRecordToSourceForeignKey, relationFixer, null, true, this.originalMapRelation.isFetchSeparately());
    }

    static class InMemoryRelationHolder<I, ENTRY_KEY, ENTRY_VALUE, KEY_ENTITY, VALUE_ENTITY> {
        private final ThreadLocal<Map<I, Trio>> relationCollectionPerEntity = new ThreadLocal();

        public void storeRelation(I source, ENTRY_KEY keyLookup, ENTRY_VALUE entryValue) {
            Map<I, Trio> srcidcMap = this.relationCollectionPerEntity.get();
            Trio relatedDuos = srcidcMap.computeIfAbsent(source, id -> new Trio());
            relatedDuos.entries.put(keyLookup, entryValue);
        }

        public void storeKeyEntity(I source, ENTRY_KEY keyLookup, KEY_ENTITY entity) {
            Map<I, Trio> srcidcMap = this.relationCollectionPerEntity.get();
            Trio relatedDuos = srcidcMap.computeIfAbsent(source, id -> new Trio());
            relatedDuos.entity1.put(keyLookup, entity);
        }

        public void storeValueEntity(I source, ENTRY_VALUE keyLookup, VALUE_ENTITY entity) {
            Map<I, Trio> srcidcMap = this.relationCollectionPerEntity.get();
            Trio relatedDuos = srcidcMap.computeIfAbsent(source, id -> new Trio());
            relatedDuos.entity2.put(keyLookup, entity);
        }

        public Collection<Duo<KEY_ENTITY, VALUE_ENTITY>> get(I src) {
            Map<I, Trio> currentMap = this.relationCollectionPerEntity.get();
            return (Collection)Nullable.nullable(currentMap).map(m -> (Trio)m.get(src)).map(Trio::assemble).get();
        }

        public void init() {
            this.relationCollectionPerEntity.set(new HashMap());
        }

        public void clear() {
            this.relationCollectionPerEntity.remove();
        }

        public class Trio {
            private final Map<ENTRY_KEY, ENTRY_VALUE> entries = new HashMap();
            private final Map<ENTRY_KEY, KEY_ENTITY> entity1 = new HashMap();
            private final Map<ENTRY_VALUE, VALUE_ENTITY> entity2 = new HashMap();

            Collection<Duo<KEY_ENTITY, VALUE_ENTITY>> assemble() {
                return this.entries.entrySet().stream().map(entry -> new Duo(this.entity1.get(entry.getKey()), this.entity2.get(entry.getValue()))).collect(Collectors.toSet());
            }
        }
    }
}

