/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.trace.ObjectPrinterBuilder;

class PartialRepresentation<T>
implements Representation {
    private final Class<T> managedType;
    private final ObjectPrinterBuilder.ObjectPrinter<T> printer;

    public PartialRepresentation(Class<T> managedType, ObjectPrinterBuilder.ObjectPrinter<T> printer) {
        this.managedType = managedType;
        this.printer = printer;
    }

    public String toStringOf(Object object) {
        if (object instanceof Iterable) {
            StringAppender result = new StringAppender();
            for (Object o : (Iterable)object) {
                String representation = o == null ? "null" : (this.managedType.isInstance(o) ? this.printer.toString(o) : new StandardRepresentation().toStringOf(object));
                result.cat((Object)representation, (Object)",\r\n");
            }
            return result.cutTail(3).wrap((Object)"{", (Object)"}").toString();
        }
        return this.printer.toString(object);
    }

    public String unambiguousToStringOf(Object object) {
        return object.getClass() + "@" + Integer.toHexString(System.identityHashCode(object));
    }
}

