/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.derivation;

import java.util.ArrayList;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.operator.Between;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.InIgnoreCase;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Lesser;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.tool.collection.Arrays;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public abstract class AbstractDerivedQuery<T> {
    private final Class<T> entityType;

    public AbstractDerivedQuery(Class<T> entityType) {
        this.entityType = entityType;
    }

    public Criterion convertToCriterion(Part part) {
        return this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
    }

    private Criterion convertToCriterion(Part.Type type, boolean ignoreCase) {
        Like operator = null;
        switch (type) {
            case BETWEEN: {
                operator = new Between();
                break;
            }
            case IS_NOT_NULL: {
                operator = new IsNull().not();
                break;
            }
            case IS_NULL: {
                operator = new IsNull();
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                operator = new Lesser();
                break;
            }
            case LESS_THAN_EQUAL: {
                operator = new Lesser().equals();
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                operator = new Greater();
                break;
            }
            case GREATER_THAN_EQUAL: {
                operator = new Greater().equals();
                break;
            }
            case NOT_LIKE: {
                operator = new Like(false, false).not();
                if (!ignoreCase) break;
                operator = operator.ignoringCase();
                break;
            }
            case LIKE: {
                operator = new Like(false, false);
                if (!ignoreCase) break;
                operator = operator.ignoringCase();
                break;
            }
            case STARTING_WITH: {
                operator = Like.startsWith();
                break;
            }
            case ENDING_WITH: {
                operator = Like.endsWith();
                break;
            }
            case IS_NOT_EMPTY: {
                break;
            }
            case IS_EMPTY: {
                break;
            }
            case NOT_CONTAINING: {
                operator = Like.contains().not();
                break;
            }
            case CONTAINING: {
                operator = Like.contains();
                break;
            }
            case NOT_IN: {
                operator = new In().not();
                if (!ignoreCase) break;
                operator = ((In)operator).ignoringCase();
                break;
            }
            case IN: {
                operator = new In();
                if (!ignoreCase) break;
                operator = ((In)operator).ignoringCase();
                break;
            }
            case TRUE: {
                operator = new Equals((Object)true);
                break;
            }
            case FALSE: {
                operator = new Equals((Object)false);
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                operator = new Equals().not();
                if (!ignoreCase) break;
                operator = ((Equals)operator).ignoringCase();
                break;
            }
            case SIMPLE_PROPERTY: {
                operator = new Equals();
                if (!ignoreCase) break;
                operator = ((Equals)operator).ignoringCase();
                break;
            }
        }
        if (operator == null) {
            throw new UnsupportedOperationException("Unsupported operator type: " + type);
        }
        if (operator instanceof Between) {
            return new BetweenCriterion((Between)operator);
        }
        if (operator instanceof In || operator instanceof InIgnoreCase) {
            return new InCriterion((ConditionalOperator<?, ?>)operator);
        }
        if (operator instanceof IsNull) {
            return new IsNullCriterion((IsNull)operator);
        }
        if (type == Part.Type.TRUE || type == Part.Type.FALSE) {
            return new BooleanCriterion((ConditionalOperator<?, ?>)operator);
        }
        return new Criterion((ConditionalOperator)operator);
    }

    protected <O> AccessorChain<T, O> convertToAccessorChain(Sort.Order property) {
        return this.convertToAccessorChain(PropertyPath.from((String)property.getProperty(), this.entityType));
    }

    protected <O> AccessorChain<T, O> convertToAccessorChain(PropertyPath property) {
        ArrayList accessorChain = new ArrayList();
        property.forEach(path -> accessorChain.add(Accessors.accessor((Class)path.getOwningType().getType(), (String)path.getSegment())));
        return new AccessorChain(accessorChain);
    }

    private static class BooleanCriterion
    extends Criterion {
        public BooleanCriterion(ConditionalOperator<?, ?> operator) {
            super(operator, 0);
        }

        @Override
        public void setValue(Object[] arguments, int argumentIndex) {
        }
    }

    private static class InCriterion
    extends Criterion {
        public InCriterion(ConditionalOperator<?, ?> operator) {
            super(operator, 2);
        }

        @Override
        public Object convert(Object[] arguments, int argumentIndex) {
            Object argument = arguments[argumentIndex];
            if (argument instanceof Object[]) {
                return Arrays.asList((Object[])((Object[])argument));
            }
            return argument;
        }
    }

    private static class IsNullCriterion
    extends Criterion {
        public IsNullCriterion(IsNull operator) {
            super((ConditionalOperator<?, ?>)operator, 0);
        }

        @Override
        public void setValue(Object[] arguments, int argumentIndex) {
        }
    }

    private static class BetweenCriterion
    extends Criterion {
        public BetweenCriterion(Between<?> operator) {
            super((ConditionalOperator<?, ?>)operator, 2);
        }

        @Override
        public Object convert(Object[] arguments, int argumentIndex) {
            return new Between.Interval(arguments[argumentIndex], arguments[argumentIndex + 1]);
        }
    }

    public static class Criterion {
        protected final ConditionalOperator<Object, Object> condition;
        protected final int argumentCount;

        private Criterion(ConditionalOperator<?, ?> condition) {
            this(condition, 1);
        }

        public Criterion(ConditionalOperator<?, ?> condition, int argumentCount) {
            this.condition = condition;
            this.argumentCount = argumentCount;
        }

        public void setValue(Object[] arguments, int argumentIndex) {
            this.condition.setValue(this.convert(arguments, argumentIndex));
        }

        protected Object convert(Object[] arguments, int argumentIndex) {
            return arguments[argumentIndex];
        }
    }
}

