/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.configurer.builder.BuildLifeCycleListener;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;

public class RelationalEntityFinder<C, I, T extends Table<T>>
implements EntityFinder<C, I> {
    private static final String PRIMARY_KEY_ALIAS = "rootId";
    private final EntityJoinTree<C, I> entityJoinTree;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;
    private final EntityCriteriaSupport<C> criteriaSupport;
    private SelectExecutor<C, I> selectExecutor;
    private EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery;
    private Query query;
    private SQLOperation.SQLOperationListener<?> operationListener;

    public RelationalEntityFinder(EntityJoinTree<C, I> entityJoinTree, SelectExecutor<C, I> selectExecutor, ConnectionProvider connectionProvider, Dialect dialect) {
        this.entityJoinTree = entityJoinTree;
        this.selectExecutor = selectExecutor;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)dialect.getColumnBinderRegistry()).buildSelectQuery();
        this.criteriaSupport = new EntityCriteriaSupport<C>(this.entityJoinTree);
        PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new BuildLifeCycleListener(){

            @Override
            public void afterBuild() {
            }

            @Override
            public void afterAllBuild() {
                RelationalEntityFinder.this.buildQuery();
            }
        });
    }

    public RelationalEntityFinder(AdvancedEntityPersister<C, I> mainPersister, ConnectionProvider connectionProvider, Dialect dialect, boolean withImmediateQueryBuild) {
        this.entityJoinTree = mainPersister.getEntityJoinTree();
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)dialect.getColumnBinderRegistry()).buildSelectQuery();
        this.criteriaSupport = new EntityCriteriaSupport<C>(this.entityJoinTree, withImmediateQueryBuild);
    }

    private void buildQuery() {
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        this.query = this.entityTreeQuery.getQuery();
    }

    @Override
    public void setOperationListener(SQLOperation.SQLOperationListener<?> operationListener) {
        this.operationListener = operationListener;
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.entityJoinTree;
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport(this, this.criteriaSupport.copy());
    }

    public Set<C> selectFromQueryBean(String sql, Map<String, Object> values) {
        HashMap parameterBinders = new HashMap();
        values.forEach((paramName, value) -> {
            PreparedStatementWriter writer = this.dialect.getColumnBinderRegistry().getWriter(value.getClass());
            parameterBinders.put((String)paramName, (PreparedStatementWriter<?>)writer);
        });
        return this.selectFromQueryBean(sql, values, parameterBinders);
    }

    public Set<C> selectFromQueryBean(String sql, Map<String, Object> values, Map<String, PreparedStatementWriter<?>> parameterBinders) {
        EntityTreeInflater<C> inflater = this.entityTreeQuery.getInflater();
        Query query = this.entityTreeQuery.getQuery();
        HashMap selectParameterBinders = new HashMap();
        HashMap aliases = new HashMap();
        query.getColumns().forEach(selectable -> {
            ResultSetReader reader;
            String alias = (String)Objects.preventNull(query.getAliases().get(selectable), (Object)selectable.getExpression());
            if (selectable instanceof Column) {
                reader = this.dialect.getColumnBinderRegistry().getReader((Object)((Column)selectable));
                selectParameterBinders.put(selectable, reader);
            } else {
                reader = this.dialect.getColumnBinderRegistry().getReader(selectable.getJavaType());
            }
            selectParameterBinders.put(selectable, reader);
            aliases.put((Selectable<?>)selectable, alias);
        });
        StringParamedSQL statement = new StringParamedSQL(sql, parameterBinders);
        statement.setValues(values);
        return new InternalExecutor(inflater, selectParameterBinders, aliases).execute(statement);
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, Map<String, Object> valuesPerParam, OrderBy orderBy, Limit limit) {
        if (where.hasCollectionCriteria()) {
            Query queryClone = new Query(new Select(), this.entityTreeQuery.getQuery().getFromDelegate(), new Where(where.getCriteria()), new GroupBy(), new Having(), orderBy, limit);
            QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
            Column pk = (Column)Iterables.first((Iterable)((Table)this.entityJoinTree.getRoot().getTable()).getPrimaryKey().getColumns());
            queryClone.select((Selectable)pk, PRIMARY_KEY_ALIAS);
            Maps.ChainingMap aliases = Maps.asMap((Object)pk, (Object)PRIMARY_KEY_ALIAS);
            Maps.ChainingMap columnReaders = Maps.asMap((Object)pk, (Object)this.dialect.getColumnBinderRegistry().getBinder((Object)pk));
            Set<I> ids = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), (Map<Column<?, ?>, ResultSetReader<?>>)columnReaders, (Map<Column<?, ?>, String>)aliases);
            if (ids.isEmpty()) {
                return Collections.emptySet();
            }
            return this.selectExecutor.select(ids);
        }
        Query queryClone = new Query(new Select(this.entityTreeQuery.getQuery().getSelectDelegate()), this.entityTreeQuery.getQuery().getFromDelegate(), new Where(where.getCriteria()), new GroupBy(), new Having(), orderBy, limit);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(valuesPerParam);
        return new InternalExecutor(this.entityTreeQuery).execute(preparedSQL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<I> readIds(PreparedSQL preparedSQL, Map<Column<?, ?>, ResultSetReader<?>> columnReaders, Map<Column<?, ?>, String> aliases) {
        EntityInflater<C, I> entityInflater = this.entityJoinTree.getRoot().getEntityInflater();
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(closeableOperation.execute(), columnReaders, aliases);
            Set set = (Set)Iterables.collect(() -> rowIterator, row -> entityInflater.giveIdentifier((ColumnedRow)row), HashSet::new);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Map<String, Object> values, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, ConfiguredEntityCriteria where, boolean distinct, OrderBy orderBy, Limit limit) {
        Query queryClone = new Query(new Select(), this.query.getFromDelegate(), new Where(where.getCriteria()), new GroupBy(), new Having(), orderBy, limit);
        queryClone.getSelectDelegate().setDistinct(distinct);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
        selectAdapter.accept(queryClone.getSelectDelegate());
        Map columnReaders = Iterables.map((Iterable)queryClone.getColumns(), Function.identity(), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(values);
        return this.readProjection(preparedSQL, columnReaders, queryClone.getAliases(), accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, O> R readProjection(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(closeableOperation.execute(), columnReaders, aliases);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> arg_0 -> ((ColumnedRow)row).get(arg_0)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private class InternalExecutor {
        private final EntityTreeInflater<C> inflater;
        private final Map<Selectable<?>, ResultSetReader<?>> selectParameterBinders;
        private final Map<Selectable<?>, String> columnAliases;

        private InternalExecutor(EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery) {
            this(entityTreeQuery.getInflater(), entityTreeQuery.getSelectParameterBinders(), entityTreeQuery.getColumnAliases());
        }

        public InternalExecutor(EntityTreeInflater<C> inflater, Map<Selectable<?>, ? extends ResultSetReader<?>> selectParameterBinders, Map<Selectable<?>, String> columnAliases) {
            this.inflater = inflater;
            this.selectParameterBinders = selectParameterBinders;
            this.columnAliases = columnAliases;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected <ParamType> Set<C> execute(SQLStatement<ParamType> query) {
            try (ReadOperation readOperation = RelationalEntityFinder.this.dialect.getReadOperationFactory().createInstance(query, RelationalEntityFinder.this.connectionProvider);){
                readOperation.setListener(RelationalEntityFinder.this.operationListener);
                readOperation.setValues(query.getValues());
                Set set = this.transform(readOperation);
                return set;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(query.getSQL(), (Throwable)e);
            }
        }

        protected Set<C> transform(ReadOperation<?> closeableOperation) {
            ResultSet resultSet = closeableOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, this.selectParameterBinders, this.columnAliases);
            return this.transform((Iterator<? extends ColumnedRow>)rowIterator);
        }

        protected Set<C> transform(Iterator<? extends ColumnedRow> rowIterator) {
            return this.inflater.transform(() -> rowIterator, 50);
        }
    }
}

