/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.VisibleForTesting;

public abstract class AbstractIdentification<C, I> {
    private final ReversibleAccessor<C, I> idAccessor;
    private final EntityMappingConfiguration<C, I> identificationDefiner;
    private final EntityMappingConfiguration.KeyMapping<C, I> keyLinkage;
    private IdentifierInsertionManager<C, I> insertionManager;
    private AlreadyAssignedIdentifierManager<C, I> fallbackInsertionManager;

    public static <C, I> SingleColumnIdentification<C, I> forSingleKey(EntityMappingConfiguration<C, I> identificationDefiner) {
        return new SingleColumnIdentification(identificationDefiner, ((EntityMappingConfiguration.SingleKeyMapping)identificationDefiner.getKeyMapping()).getIdentifierPolicy());
    }

    public static <C, I> CompositeKeyIdentification<C, I> forCompositeKey(EntityMappingConfiguration<C, I> identificationDefiner, EntityMappingConfiguration.CompositeKeyMapping<C, I> foundKeyMapping) {
        return new CompositeKeyIdentification<C, I>(identificationDefiner, foundKeyMapping.getMarkAsPersistedFunction(), foundKeyMapping.getIsPersistedFunction());
    }

    private AbstractIdentification(EntityMappingConfiguration<C, I> identificationDefiner) {
        this.keyLinkage = identificationDefiner.getKeyMapping();
        this.idAccessor = identificationDefiner.getKeyMapping().getAccessor();
        this.identificationDefiner = identificationDefiner;
    }

    public EntityMappingConfiguration.KeyMapping<C, I> getKeyLinkage() {
        return this.keyLinkage;
    }

    public ReversibleAccessor<C, I> getIdAccessor() {
        return this.idAccessor;
    }

    public EntityMappingConfiguration<C, I> getIdentificationDefiner() {
        return this.identificationDefiner;
    }

    public IdentifierInsertionManager<C, I> getInsertionManager() {
        return this.insertionManager;
    }

    public AbstractIdentification<C, I> setInsertionManager(IdentifierInsertionManager<C, I> insertionManager) {
        this.insertionManager = insertionManager;
        return this;
    }

    public AlreadyAssignedIdentifierManager<C, I> getFallbackInsertionManager() {
        return this.fallbackInsertionManager;
    }

    public AbstractIdentification<C, I> setFallbackInsertionManager(AlreadyAssignedIdentifierManager<C, I> fallbackInsertionManager) {
        this.fallbackInsertionManager = fallbackInsertionManager;
        return this;
    }

    public static class CompositeKeyIdentification<C, I>
    extends AbstractIdentification<C, I> {
        private final Consumer<C> markAsPersistedFunction;
        private final Function<C, Boolean> isPersistedFunction;
        private Map<ReversibleAccessor<I, Object>, Column<Table, Object>> compositeKeyMapping;

        @VisibleForTesting
        public CompositeKeyIdentification(EntityMappingConfiguration<C, I> identificationDefiner, Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
            super(identificationDefiner);
            this.markAsPersistedFunction = markAsPersistedFunction;
            this.isPersistedFunction = isPersistedFunction;
        }

        public Consumer<C> getMarkAsPersistedFunction() {
            return this.markAsPersistedFunction;
        }

        public Function<C, Boolean> getIsPersistedFunction() {
            return this.isPersistedFunction;
        }

        public Map<ReversibleAccessor<I, Object>, Column<Table, Object>> getCompositeKeyMapping() {
            return this.compositeKeyMapping;
        }

        public void setCompositeKeyMapping(Map<? extends ReversibleAccessor<I, Object>, ? extends Column<?, Object>> compositeKeyMapping) {
            this.compositeKeyMapping = compositeKeyMapping;
        }
    }

    public static class SingleColumnIdentification<C, I>
    extends AbstractIdentification<C, I> {
        private final IdentifierPolicy<I> identifierPolicy;

        private SingleColumnIdentification(EntityMappingConfiguration<C, I> identificationDefiner, IdentifierPolicy<I> identifierPolicy) {
            super(identificationDefiner);
            this.identifierPolicy = identifierPolicy;
        }

        public IdentifierPolicy<I> getIdentifierPolicy() {
            return this.identifierPolicy;
        }
    }
}

