/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.transaction;

import java.sql.Connection;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class StalactitePlatformTransactionManager
extends JdbcTransactionManager
implements SeparateTransactionExecutor {
    public StalactitePlatformTransactionManager(DataSource dataSource) {
        super(dataSource);
    }

    public Connection giveConnection() {
        ConnectionHolder resource = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
        return resource.getConnection();
    }

    public void executeInNewTransaction(final SeparateTransactionExecutor.JdbcOperation jdbcOperation) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)this);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                jdbcOperation.execute();
            }
        });
    }
}

