/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.SerializableTriConsumer;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBiFunction;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class MethodReferences {
    private static final MethodReferenceCapturer SINGLETON = new MethodReferenceCapturer();

    public static <A, B> String toMethodReferenceString(SerializableFunction<A, B> methodReference) {
        Method method = SINGLETON.findMethod(methodReference);
        return MethodReferences.toMethodReferenceString(method);
    }

    public static <A, B, C> String toMethodReferenceString(SerializableBiFunction<A, B, C> methodReference) {
        Method method = SINGLETON.findMethod(methodReference);
        return MethodReferences.toMethodReferenceString(method);
    }

    public static <A, B, C, D> String toMethodReferenceString(SerializableTriFunction<A, B, C, D> methodReference) {
        Method method = SINGLETON.findMethod(methodReference);
        return MethodReferences.toMethodReferenceString(method);
    }

    public static <A> String toMethodReferenceString(SerializableConsumer<A> methodReference) {
        Method method = SINGLETON.findMethod(methodReference);
        return MethodReferences.toMethodReferenceString(method);
    }

    public static <A, B> String toMethodReferenceString(SerializableBiConsumer<A, B> methodReference) {
        Method method = SINGLETON.findMethod(methodReference);
        return MethodReferences.toMethodReferenceString(method);
    }

    public static <A, B, C> String toMethodReferenceString(SerializableTriConsumer<A, B, C> methodReference) {
        Method method = SINGLETON.findMethod(methodReference);
        return MethodReferences.toMethodReferenceString(method);
    }

    public static String toMethodReferenceString(Method method) {
        return method.getDeclaringClass().getSimpleName() + "::" + method.getName();
    }

    public static int hashCodeMethodReference(Serializable methodReference) {
        SerializedLambda serializedLambda = MethodReferences.buildSerializedLambda(methodReference);
        String lambdaSignature = MethodReferences.getTargetMethodRawSignature(serializedLambda);
        return lambdaSignature.hashCode();
    }

    public static String getTargetMethodRawSignature(SerializedLambda serializedLambda) {
        return serializedLambda.getImplClass().concat(serializedLambda.getImplMethodName()).concat(serializedLambda.getImplMethodSignature());
    }

    public static <O> SerializedLambda buildSerializedLambda(SerializableSupplier<O> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static <T, O> SerializedLambda buildSerializedLambda(SerializableFunction<T, O> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static <I1, I2, O> SerializedLambda buildSerializedLambda(SerializableBiFunction<I1, I2, O> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static <I1, I2, I3, O> SerializedLambda buildSerializedLambda(SerializableTriFunction<I1, I2, I3, O> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static <T> SerializedLambda buildSerializedLambda(SerializableConsumer<T> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static <T, U> SerializedLambda buildSerializedLambda(SerializableBiConsumer<T, U> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static <T, U, V> SerializedLambda buildSerializedLambda(SerializableTriConsumer<T, U, V> methodReference) {
        return MethodReferences.buildSerializedLambda(methodReference);
    }

    public static SerializedLambda buildSerializedLambda(Serializable methodReference) {
        Object serializedForm;
        Method writeReplace = Reflections.getMethod(methodReference.getClass(), (String)"writeReplace", (Class[])new Class[0]);
        writeReplace.setAccessible(true);
        try {
            serializedForm = writeReplace.invoke((Object)methodReference, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        return (SerializedLambda)serializedForm;
    }

    public static Class giveImplementingClass(SerializedLambda serializedLambda) {
        String implementationClass = serializedLambda.getImplClass().replace('/', '.');
        return Reflections.forName((String)implementationClass);
    }

    public static Class giveInstantiatedClass(SerializedLambda serializedLambda) {
        String instantiatedMethodType = serializedLambda.getInstantiatedMethodType();
        int closingParenthesisIndex = instantiatedMethodType.indexOf(41);
        String implementingClassAndArgumentsTypes = instantiatedMethodType.substring(1, closingParenthesisIndex);
        List types = Strings.split((String)implementingClassAndArgumentsTypes, (char)';', (boolean)true);
        return Reflections.forName((String)((String)types.get(0)).replace("/", "."));
    }
}

