/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.ArrayAccessor;
import org.codefilarete.reflection.ListAccessor;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;

public class AccessorChainMutator<C, X, T>
extends AccessorChain<C, X>
implements ReversibleMutator<C, T> {
    private static final ThreadLocal<Accessor> CURRENT_NULL_RETURNING_MUTATOR = new ThreadLocal();
    private final Mutator<X, T> mutator;

    public AccessorChainMutator(List<? extends Accessor<?, ?>> accessors, Mutator<X, T> mutator) {
        super(accessors);
        this.mutator = mutator;
    }

    public AccessorChainMutator(AccessorChain<C, X> accessors, Mutator<X, T> mutator) {
        super(accessors.getAccessors());
        this.mutator = mutator;
    }

    public Mutator<X, T> getMutator() {
        return this.mutator;
    }

    @Override
    public void set(C c, T t) {
        Object[] finalTarget = new Object[1];
        ThreadLocals.doWithThreadLocal(CURRENT_NULL_RETURNING_MUTATOR, () -> null, () -> {
            Object target = this.get(c);
            if (target == null) {
                this.throwNullPointerException(c);
            }
            finalTarget[0] = target;
        });
        this.mutator.set(finalTarget[0], t);
    }

    @Override
    protected Object onNullValue(Object targetBean, Accessor accessor) {
        CURRENT_NULL_RETURNING_MUTATOR.set(accessor);
        return super.onNullValue(targetBean, accessor);
    }

    private void throwNullPointerException(Object srcBean) {
        String accessorDescription = new AccessorPathBuilder().ccat(this.getAccessors(), ".").toString();
        Accessor nullReturningMutator = CURRENT_NULL_RETURNING_MUTATOR.get();
        List pathToNullPointerException = Iterables.head(this.getAccessors(), (Object)nullReturningMutator);
        pathToNullPointerException.add(nullReturningMutator);
        String nullProviderDescription = new AccessorPathBuilder().ccat(pathToNullPointerException, ".").toString();
        throw new NullPointerException("Call of " + accessorDescription + " on " + srcBean + " returned null, because " + nullProviderDescription + " returned null");
    }

    @Override
    public AccessorChain<C, T> toAccessor() {
        if (this.mutator instanceof ReversibleMutator) {
            ArrayList newAccessors = new ArrayList(this.getAccessors());
            newAccessors.add(((ReversibleMutator)this.mutator).toAccessor());
            return new AccessorChain(newAccessors);
        }
        throw new UnsupportedOperationException("Last mutator cannot be reverted because it doesn't implement " + Reflections.toString(ReversibleAccessor.class) + ": " + this.mutator);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.mutator.equals(((AccessorChainMutator)other).mutator);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.mutator.hashCode();
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + " <- " + this.mutator.toString();
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @VisibleForTesting
    static class AccessorPathBuilder
    extends StringAppender {
        AccessorPathBuilder() {
        }

        public StringAppender cat(Object o) {
            if (o instanceof AccessorByMember) {
                super.cat((Object)((AccessorByMember)o).getGetter().getName());
                if (((AccessorByMember)o).getGetter() instanceof Method) {
                    super.cat((Object)"(");
                    if (o instanceof ListAccessor) {
                        super.cat((Object)((ListAccessor)o).getIndex());
                    } else if (((Method)((AccessorByMember)o).getGetter()).getParameterCount() > 0) {
                        super.cat((Object)"..");
                    }
                    super.cat((Object)")");
                }
                return this;
            }
            if (o instanceof AccessorByMethodReference) {
                super.cat((Object)(((AccessorByMethodReference)o).getMethodName() + "()"));
                return this;
            }
            if (o instanceof ArrayAccessor) {
                return super.cat((Object)("[" + ((ArrayAccessor)o).getIndex() + "]"));
            }
            return super.cat(o);
        }
    }
}

