/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;

public class ValueAccessPointComparator
implements Comparator<ValueAccessPoint> {
    private final Map<ValueAccessPoint, AccessorDefinition> cache;

    public ValueAccessPointComparator() {
        this(new HashMap<ValueAccessPoint, AccessorDefinition>());
    }

    public ValueAccessPointComparator(Map<ValueAccessPoint, AccessorDefinition> cache) {
        this.cache = cache;
    }

    @Override
    public int compare(ValueAccessPoint o1, ValueAccessPoint o2) {
        AccessorDefinition accessorDefinition1 = this.cache.computeIfAbsent(o1, AccessorDefinition::giveDefinition);
        AccessorDefinition accessorDefinition2 = this.cache.computeIfAbsent(o2, AccessorDefinition::giveDefinition);
        return this.compareTo(accessorDefinition1, accessorDefinition2);
    }

    protected int compareTo(AccessorDefinition o1, AccessorDefinition o2) {
        int comparison = o2.getDeclaringClass().getName().compareTo(o1.getDeclaringClass().getName());
        if (comparison == 0 && (comparison = o2.getName().compareTo(o1.getName())) == 0) {
            comparison = o2.getMemberType().toString().compareTo(o1.getMemberType().toString());
        }
        return comparison;
    }
}

