/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.Array;
import org.codefilarete.reflection.AbstractMutator;
import org.codefilarete.reflection.ArrayAccessor;
import org.codefilarete.reflection.ReversibleMutator;

public class ArrayMutator<C>
extends AbstractMutator<C, C>
implements ReversibleMutator<C, C> {
    private int index;
    private final ArrayAccessor<C> accessor;

    public ArrayMutator() {
        this.accessor = new ArrayAccessor(0, this);
    }

    public ArrayMutator(int index) {
        this.index = index;
        this.accessor = new ArrayAccessor(index, this);
    }

    public ArrayMutator(int index, ArrayAccessor<C> accessor) {
        this.index = index;
        this.accessor = accessor;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void set(C[] cs, C c) {
        cs[this.index] = c;
    }

    @Override
    public void set(C c, C other) {
        try {
            this.doSet(c, other);
        }
        catch (Throwable throwable) {
            this.handleException(throwable, c, new Object[0]);
        }
    }

    @Override
    protected void doSet(C cs, C c) {
        Array.set(cs, this.getIndex(), c);
    }

    @Override
    protected String getSetterDescription() {
        return "array mutator on index " + this.index;
    }

    public ArrayAccessor<C> toAccessor() {
        return this.accessor;
    }
}

