/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.NonReversibleAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointByMethod;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.ThreadSafeLazyInitializer;

public class AccessorByMethod<C, T>
extends AbstractAccessor<C, T>
implements AccessorByMember<C, T, Method>,
ReversibleAccessor<C, T>,
ValueAccessPointByMethod<C> {
    private final Method getter;
    private final Object[] methodParameters;
    private final Supplier<Mutator<C, T>> mutator;

    public AccessorByMethod(Method getter) {
        this(getter, new Object[getter.getParameterTypes().length]);
    }

    public AccessorByMethod(Method getter, Object ... arguments) {
        Reflections.ensureAccessible((AccessibleObject)getter);
        this.getter = getter;
        this.methodParameters = arguments;
        this.mutator = new ThreadSafeLazyInitializer<Mutator<C, T>>(){

            protected Mutator<C, T> createInstance() {
                return AccessorByMethod.this.findCompatibleMutator();
            }
        };
    }

    AccessorByMethod(Method getter, Object[] methodParameters, Mutator<C, T> mutator) {
        this.getter = getter;
        this.methodParameters = methodParameters;
        this.mutator = () -> mutator;
    }

    public AccessorByMethod(Class<C> declaringClass, String getterName) {
        this(Reflections.getMethod(declaringClass, (String)getterName, (Class[])new Class[0]));
    }

    public <I> AccessorByMethod(Class<C> declaringClass, String methodName, Class<I> inputType, I input) {
        this(Reflections.getMethod(declaringClass, (String)methodName, (Class[])new Class[]{inputType}), input);
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public Method getMethod() {
        return this.getGetter();
    }

    @Override
    public Class<T> getPropertyType() {
        return this.getMethod().getReturnType();
    }

    @Override
    public T get(C c) {
        return this.get(c, this.methodParameters);
    }

    public AccessorByMethod<C, T> setParameters(Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.setParameter(i, values[i]);
        }
        return this;
    }

    public AccessorByMethod<C, T> setParameter(int index, Object value) {
        this.methodParameters[index] = value;
        return this;
    }

    public Object getParameter(@Nonnegative int index) {
        return this.methodParameters[index];
    }

    public T get(@Nonnull C c, Object ... params) {
        try {
            return this.doGet(c, params);
        }
        catch (ReflectiveOperationException | RuntimeException t) {
            this.handleException(t, c, params);
            return null;
        }
    }

    @Override
    protected final T doGet(C c) throws IllegalAccessException, InvocationTargetException {
        return this.doGet(c, new Object[0]);
    }

    protected T doGet(C c, Object ... args) throws IllegalAccessException, InvocationTargetException {
        return (T)this.getGetter().invoke(c, args);
    }

    @Override
    protected String getGetterDescription() {
        return Reflections.toString((Method)this.getGetter());
    }

    @Override
    public Mutator<C, T> toMutator() {
        return this.mutator.get();
    }

    private MutatorByMember<C, T, ? extends Member> findCompatibleMutator() {
        String propertyName;
        Class<?> declaringClass = this.getter.getDeclaringClass();
        MutatorByMethod<?, ?> mutatorByMethod = Accessors.mutatorByMethod(declaringClass, propertyName = Reflections.propertyName((Method)this.getter), this.getter.getReturnType(), this);
        if (mutatorByMethod == null) {
            try {
                return Accessors.mutatorByField(declaringClass, propertyName, this);
            }
            catch (Reflections.MemberNotFoundException e) {
                throw new NonReversibleAccessor("Can't find a mutator for " + Reflections.toString((Method)this.getter), e);
            }
        }
        return mutatorByMethod;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof AccessorByMethod && this.getGetter().toString().equals(((AccessorByMethod)other).getGetter().toString()) && Arrays.equals(this.methodParameters, ((AccessorByMethod)other).methodParameters);
    }

    @Override
    public int hashCode() {
        return 31 * this.getGetter().hashCode() + Arrays.hashCode(this.methodParameters);
    }
}

