/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.codefilarete.reflection.AbstractMutator;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPointByField;
import org.codefilarete.tool.Reflections;

public class MutatorByField<C, T>
extends AbstractMutator<C, T>
implements MutatorByMember<C, T, Field>,
ReversibleMutator<C, T>,
ValueAccessPointByField {
    private final Field field;
    private final Accessor<C, T> accessor;

    public MutatorByField(Field field) {
        Reflections.ensureAccessible((AccessibleObject)field);
        this.field = field;
        this.accessor = new AccessorByField(field, this);
    }

    MutatorByField(Field field, Accessor<C, T> accessor) {
        this.field = field;
        this.accessor = accessor;
    }

    @Override
    public Field getSetter() {
        return this.field;
    }

    @Override
    public Field getField() {
        return this.getSetter();
    }

    @Override
    public Class<T> getPropertyType() {
        return this.field.getType();
    }

    @Override
    protected void doSet(C c, T t) throws IllegalAccessException {
        this.getSetter().set(c, t);
    }

    @Override
    protected String getSetterDescription() {
        return "mutator for field " + Reflections.toString((Field)this.getSetter());
    }

    @Override
    public Accessor<C, T> toAccessor() {
        return this.accessor;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof MutatorByField && this.getSetterDescription().equals(((MutatorByField)other).getSetterDescription());
    }

    @Override
    public int hashCode() {
        return this.getSetter().hashCode();
    }
}

