/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.SerializableTriConsumer;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBiFunction;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class MethodReferenceCapturer {
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private final Map<String, Executable> cache;

    public MethodReferenceCapturer() {
        this(1000);
    }

    public MethodReferenceCapturer(int cacheSize) {
        this.cache = new LRUCache(cacheSize);
    }

    public <I, O> Method findMethod(SerializableFunction<I, O> methodReference) {
        return this.findMethod(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1, O> Method findMethod(SerializableBiFunction<I, A1, O> methodReference) {
        return this.findMethod(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1, A2, O> Method findMethod(SerializableTriFunction<I, A1, A2, O> methodReference) {
        return this.findMethod(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I> Method findMethod(SerializableConsumer<I> methodReference) {
        return this.findMethod(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1> Method findMethod(SerializableBiConsumer<I, A1> methodReference) {
        return this.findMethod(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1, A2> Method findMethod(SerializableTriConsumer<I, A1, A2> methodReference) {
        return this.findMethod(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <O> Constructor<O> findConstructor(SerializableSupplier<O> methodReference) {
        return this.findConstructor(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <O, A1> Constructor<O> findConstructor(SerializableFunction<A1, O> methodReference) {
        return this.findConstructor(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <A1, A2, O> Constructor<O> findConstructor(SerializableBiFunction<A1, A2, O> methodReference) {
        return this.findConstructor(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <A1, A2, A3, O> Constructor<O> findConstructor(SerializableTriFunction<A1, A2, A3, O> methodReference) {
        return this.findConstructor(MethodReferences.buildSerializedLambda(methodReference));
    }

    public Method findMethod(SerializedLambda serializedLambda) {
        String targetMethodRawSignature = MethodReferences.getTargetMethodRawSignature(serializedLambda);
        return this.handleMethodCast(this.findExecutable(serializedLambda, targetMethodRawSignature));
    }

    private Method handleMethodCast(Executable executable) {
        Method method = Reflections.getMethod(executable.getDeclaringClass(), (String)executable.getName(), (Class[])executable.getParameterTypes());
        if (method.isSynthetic() && Modifier.isStatic(executable.getModifiers())) {
            throw new UnsupportedOperationException("Found method is synthetic which means original one was wrapped by some bytecode (generally to bypass visibility constraint) : " + Reflections.toString((Method)method));
        }
        return method;
    }

    public Constructor findConstructor(SerializedLambda serializedLambda) {
        return this.handleConstructorCast(this.findExecutable(serializedLambda));
    }

    private Constructor handleConstructorCast(Executable executable) {
        try {
            return (Constructor)executable;
        }
        catch (ClassCastException e) {
            if ("java.lang.reflect.Method cannot be cast to java.lang.reflect.Constructor".equals(e.getMessage())) {
                Method method = (Method)executable;
                Class<?> returnType = method.getReturnType();
                if (!Modifier.isStatic(returnType.getModifiers())) {
                    throw new UnsupportedOperationException("Capturing by reference a non-static inner class constructor is not supported, make " + Reflections.toString(returnType) + " static or an outer class of " + Reflections.toString(returnType.getEnclosingClass()));
                }
                Constructor constructor = Reflections.getConstructor(method.getReturnType(), (Class[])method.getParameterTypes());
                Reflections.ensureAccessible((AccessibleObject)constructor);
                return constructor;
            }
            throw e;
        }
    }

    public <I, O> Executable findExecutable(SerializableFunction<I, O> methodReference) {
        return this.findExecutable(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1, O> Executable findExecutable(SerializableBiFunction<I, A1, O> methodReference) {
        return this.findExecutable(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1, A2, O> Executable findExecutable(SerializableTriFunction<I, A1, A2, O> methodReference) {
        return this.findExecutable(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I> Executable findExecutable(SerializableConsumer<I> methodReference) {
        return this.findExecutable(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1> Executable findExecutable(SerializableBiConsumer<I, A1> methodReference) {
        return this.findExecutable(MethodReferences.buildSerializedLambda(methodReference));
    }

    public <I, A1, A2> Executable findExecutable(SerializableTriConsumer<I, A1, A2> methodReference) {
        return this.findExecutable(MethodReferences.buildSerializedLambda(methodReference));
    }

    private Executable findExecutable(SerializedLambda serializedLambda) {
        String targetMethodRawSignature = MethodReferences.getTargetMethodRawSignature(serializedLambda);
        return this.findExecutable(serializedLambda, targetMethodRawSignature);
    }

    private Executable findExecutable(SerializedLambda serializedLambda, String targetExecutableRawSignature) {
        return this.cache.computeIfAbsent(targetExecutableRawSignature, s -> {
            Class[] argsClasses;
            Class<?> clazz;
            try {
                clazz = Class.forName(serializedLambda.getImplClass().replace("/", "."));
            }
            catch (ClassNotFoundException e) {
                throw Exceptions.asRuntimeException((Throwable)e);
            }
            try {
                argsClasses = MethodReferenceCapturer.giveArgumentTypes(serializedLambda).getArgumentTypes();
            }
            catch (Reflections.MemberNotFoundException e) {
                throw new Reflections.MemberNotFoundException("Can't find method reference for " + serializedLambda.getImplClass() + "." + serializedLambda.getImplMethodName(), (Throwable)e);
            }
            if (serializedLambda.getImplMethodName().equals("<init>")) {
                return Reflections.getConstructor(clazz, (Class[])argsClasses);
            }
            return Reflections.getMethod(clazz, (String)serializedLambda.getImplMethodName(), (Class[])argsClasses);
        });
    }

    public static MethodDefinition giveArgumentTypes(SerializedLambda serializedLambda) {
        Class[] argTypes;
        String methodSignature = serializedLambda.getImplMethodSignature();
        Class declaringType = Reflections.forName((String)serializedLambda.getImplClass().replace('/', '.'));
        String methodName = serializedLambda.getImplMethodName();
        int closeArgsIndex = methodSignature.indexOf(41);
        if (closeArgsIndex != 1) {
            String argumentTypeSignature = methodSignature.substring(1, closeArgsIndex);
            argTypes = new ArgumentTypeSignatureParser(argumentTypeSignature).parse();
        } else {
            argTypes = new Class[]{};
        }
        Class returnType = new ArgumentTypeSignatureParser(methodSignature.substring(closeArgsIndex + 1)).parse()[0];
        return MethodDefinition.methodDefinition(declaringType, methodName, argTypes, returnType);
    }

    public static class MethodDefinition
    extends AccessorDefinition {
        private final Class[] argumentTypes;
        private final Class returnType;

        public static MethodDefinition methodDefinition(Class declaringClass, String methodName, Class[] argumentTypes, Class returnType) {
            Class memberType;
            try {
                memberType = (Class)Reflections.onJavaBeanPropertyWrapperName((String)methodName, s -> returnType, s -> argumentTypes[0], s -> returnType);
            }
            catch (Reflections.MemberNotFoundException e) {
                memberType = null;
            }
            return new MethodDefinition(declaringClass, methodName, argumentTypes, returnType, memberType);
        }

        private MethodDefinition(Class declaringClass, String methodName, Class[] argumentTypes, Class returnType, Class memberType) {
            super(declaringClass, methodName, memberType);
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        public Class[] getArgumentTypes() {
            return this.argumentTypes;
        }

        public Class getReturnType() {
            return this.returnType;
        }
    }

    private static class ArgumentTypeSignatureParser {
        private int currPos = 0;
        private String className;
        private int typeDefSize;
        private final char[] signatureChars;

        private ArgumentTypeSignatureParser(String signature) {
            this.signatureChars = signature.toCharArray();
        }

        Class[] parse() {
            ArrayList<Class> result = new ArrayList<Class>(5);
            while (this.currPos < this.signatureChars.length) {
                boolean typeIsArray = this.signatureChars[this.currPos] == '[';
                boolean isObjectType = this.signatureChars[this.currPos + (typeIsArray ? 1 : 0)] == 'L';
                this.lookAHeadForType(isObjectType, typeIsArray);
                this.currPos += this.typeDefSize;
                result.add(Reflections.forName((String)this.className));
            }
            return result.toArray(new Class[0]);
        }

        private void lookAHeadForType(boolean isObjectType, boolean isArray) {
            if (isObjectType) {
                int typeDefEnd = this.currPos;
                while (this.signatureChars[++typeDefEnd] != ';') {
                }
                this.typeDefSize = typeDefEnd - this.currPos + 1;
                this.className = ArgumentTypeSignatureParser.cleanClassName(new String(this.signatureChars, this.currPos, this.typeDefSize));
            } else {
                this.typeDefSize = 1 + (isArray ? 1 : 0);
                this.className = new String(this.signatureChars, this.currPos, this.typeDefSize);
            }
        }

        private static String cleanClassName(String className) {
            if (className.charAt(0) == 'L') {
                className = className.substring(1, className.length() - 1);
            }
            className = className.replace('/', '.');
            return className;
        }
    }

    static class LRUCache
    extends LinkedHashMap<String, Executable> {
        private final int cacheSize;

        LRUCache(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.cacheSize;
        }
    }
}

