/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.function;

import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.codefilarete.tool.function.Functions;

public class Predicates {
    public static <E> Predicate<E> not(Predicate<E> predicate) {
        return predicate.negate();
    }

    public static <E> Predicate<E> predicate(Function<E, Boolean> booleanFunction) {
        return booleanFunction::apply;
    }

    public static <I, O> Predicate<I> predicate(Function<I, O> mapper, Predicate<O> predicate) {
        return Predicates.predicate(mapper.andThen(Functions.toFunction(predicate)));
    }

    public static <E> Comparator<E> toComparator(BiPredicate<E, E> predicate) {
        return (o1, o2) -> predicate.test(o1, o2) ? 0 : -1;
    }

    public static <I> BiPredicate<I, I> and(Function<I, ?> ... testableProperties) {
        BiPredicate<Object, Object> result = (a, b) -> true;
        for (Function printableProperty : testableProperties) {
            result = result.and((a, b) -> Predicates.equalOrNull(printableProperty.apply(a), printableProperty.apply(b)));
        }
        return result;
    }

    public static <C> Predicate<C> acceptAll() {
        return new AlwaysTrue();
    }

    public static <C> Predicate<C> rejectAll() {
        return new AlwaysFalse();
    }

    public static <T, U> boolean equalOrNull(@Nullable T o1, @Nullable U o2) {
        return Predicates.equalOrNull(o1, o2, Object::equals);
    }

    public static <T, U> boolean equalOrNull(@Nullable T t, @Nullable U u, BiPredicate<T, U> equalsNonNullDelegate) {
        return t == null && u == null || t != null && u != null && equalsNonNullDelegate.test(t, u);
    }

    private static class AlwaysFalse<C>
    implements Predicate<C> {
        private AlwaysFalse() {
        }

        @Override
        public boolean test(C o) {
            return false;
        }
    }

    private static class AlwaysTrue<C>
    implements Predicate<C> {
        private AlwaysTrue() {
        }

        @Override
        public boolean test(C o) {
            return true;
        }
    }
}

