/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Retryer;
import org.junit.jupiter.api.Test;

class RetryerTest {
    RetryerTest() {
    }

    @Test
    void execute_neverWorks() {
        Retryer testInstance = new Retryer(3, 5L){

            protected boolean shouldRetry(Retryer.Result result) {
                return result instanceof Retryer.Failure;
            }
        };
        int[] callTimes = new int[1];
        try {
            testInstance.execute(() -> {
                callTimes[0] = callTimes[0] + 1;
                throw new RuntimeException("Never works !");
            }, "test");
        }
        catch (Throwable t) {
            Assertions.assertThat((String)t.getMessage()).isEqualTo("Action \"test\" has been executed 3 times every 5ms and always failed");
            Assertions.assertThat((String)t.getCause().getMessage()).isEqualTo("Never works !");
        }
        Assertions.assertThat((int)callTimes[0]).isEqualTo(3);
    }

    @Test
    void execute_worksLastAttempt() {
        Retryer testInstance = new Retryer(3, 5L){

            protected boolean shouldRetry(Retryer.Result result) {
                return result instanceof Retryer.Failure;
            }
        };
        int[] callTimes = new int[1];
        try {
            testInstance.execute(() -> {
                callTimes[0] = callTimes[0] + 1;
                if (callTimes[0] < 2) {
                    throw new RuntimeException("Never works !");
                }
                return null;
            }, "test");
        }
        catch (Throwable t) {
            Assertions.fail((String)"No exception should be thrown");
        }
        Assertions.assertThat((int)callTimes[0]).isEqualTo(2);
    }

    @Test
    void execute_worksFirstAttempt() {
        Retryer testInstance = new Retryer(3, 5L){

            protected boolean shouldRetry(Retryer.Result result) {
                return result instanceof Retryer.Failure;
            }
        };
        int[] callTimes = new int[1];
        try {
            testInstance.execute(() -> {
                callTimes[0] = callTimes[0] + 1;
                return null;
            }, "test");
        }
        catch (Throwable t) {
            Assertions.fail((String)"No exception should be thrown");
        }
        Assertions.assertThat((int)callTimes[0]).isEqualTo(1);
    }

    @Test
    void execute_throwUnexpected() {
        Retryer testInstance = new Retryer(3, 5L){

            protected boolean shouldRetry(Retryer.Result result) {
                if (result instanceof Retryer.Failure) {
                    return ((Retryer.Failure)result).getError().getMessage().equals("retry");
                }
                return false;
            }
        };
        int[] callTimes = new int[1];
        try {
            testInstance.execute(() -> {
                callTimes[0] = callTimes[0] + 1;
                if (callTimes[0] < 3) {
                    throw new RuntimeException("retry");
                }
                throw new RuntimeException("Unepected error");
            }, "test");
        }
        catch (Throwable t) {
            Assertions.assertThat((String)t.getMessage()).isEqualTo("Unepected error");
        }
        Assertions.assertThat((int)callTimes[0]).isEqualTo(3);
    }

    @Test
    void execute_noRetryAsked() {
        Retryer testInstance = Retryer.NO_RETRY;
        int[] callTimes = new int[1];
        String result = null;
        try {
            result = (String)testInstance.execute(() -> {
                callTimes[0] = callTimes[0] + 1;
                return "OK";
            }, "test");
        }
        catch (Throwable t) {
            Assertions.fail((String)"No exception should be thrown");
        }
        Assertions.assertThat((int)callTimes[0]).isEqualTo(1);
        Assertions.assertThat((String)result).isEqualTo("OK");
    }
}

