/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.sql;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.sql.ConnectionWrapper;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ConnectionWrapperTest {
    ConnectionWrapperTest() {
    }

    @Test
    void unwrap_parameterIsConnectionClass_returnsDelegate() throws SQLException {
        Connection delegate = (Connection)Mockito.mock(Connection.class);
        ConnectionWrapper testInstance = new ConnectionWrapper(delegate);
        Assertions.assertThat((Object)testInstance.unwrap(Connection.class)).isEqualTo((Object)delegate);
    }

    @Test
    void methodsInvokeDelegateMethods() {
        Connection delegate = (Connection)Mockito.mock(Connection.class);
        ConnectionWrapper testInstance = new ConnectionWrapper(delegate);
        List dataSourceClassInheritance = Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(Connection.class, null)));
        dataSourceClassInheritance.add(0, Connection.class);
        dataSourceClassInheritance.remove(Wrapper.class);
        MethodIterator methodIterator = new MethodIterator(dataSourceClassInheritance.iterator());
        Iterable methods = () -> methodIterator;
        int methodCount = 0;
        for (Method method : methods) {
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                HashMap delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                if (method.getName().equals("getTypeMap")) {
                    delegateResult = new HashMap();
                }
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new Connection[]{delegate});
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(53);
    }
}

