/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.function;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.function.Predicates;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PredicatesTest {
    PredicatesTest() {
    }

    @Test
    void not() {
        Predicate testInstance = Predicates.not(Objects::isNull);
        Assertions.assertThat((boolean)testInstance.test("")).isTrue();
        Assertions.assertThat((boolean)testInstance.test(null)).isFalse();
    }

    @Test
    void predicate() {
        HashSet data = Arrays.asHashSet((Object[])new String[]{"a", "b", "c"});
        Predicate testInstance = Predicates.predicate(data::contains);
        Assertions.assertThat((boolean)testInstance.test("a")).isTrue();
        Assertions.assertThat((boolean)testInstance.test("d")).isFalse();
    }

    @Test
    void predicate_withMapper() {
        HashSet data = Arrays.asHashSet((Object[])new String[]{"1", "2", "3"});
        Predicate testInstance = Predicates.predicate(Object::toString, data::contains);
        Assertions.assertThat((boolean)testInstance.test(1)).isTrue();
        Assertions.assertThat((boolean)testInstance.test(4)).isFalse();
    }

    @Test
    void toCompartor() {
        Comparator comparator = Predicates.toComparator(Objects::equals);
        Assertions.assertThat((int)-1).isEqualTo(comparator.compare("a", "b"));
        Assertions.assertThat((int)-1).isEqualTo(comparator.compare("b", "a"));
        Assertions.assertThat((int)0).isEqualTo(comparator.compare("a", "a"));
    }

    @Test
    void acceptAll() {
        Assertions.assertThat((boolean)Predicates.acceptAll().test("")).isTrue();
        Assertions.assertThat((boolean)Predicates.acceptAll().test(null)).isTrue();
        Assertions.assertThat((boolean)Predicates.acceptAll().test("a")).isTrue();
        Assertions.assertThat((boolean)Predicates.acceptAll().test(42)).isTrue();
    }

    @Test
    void rejectAll() {
        Assertions.assertThat((boolean)Predicates.rejectAll().test("")).isFalse();
        Assertions.assertThat((boolean)Predicates.rejectAll().test(null)).isFalse();
        Assertions.assertThat((boolean)Predicates.rejectAll().test("a")).isFalse();
        Assertions.assertThat((boolean)Predicates.rejectAll().test(42)).isFalse();
    }

    @Test
    void equalsWithNull() {
        Assertions.assertThat((boolean)Predicates.equalOrNull(null, null)).isTrue();
        Assertions.assertThat((boolean)Predicates.equalOrNull((Object)"a", (Object)"a")).isTrue();
        Assertions.assertThat((boolean)Predicates.equalOrNull((Object)"a", (Object)"b")).isFalse();
        Assertions.assertThat((boolean)Predicates.equalOrNull((Object)"b", (Object)"a")).isFalse();
        Assertions.assertThat((boolean)Predicates.equalOrNull(null, (Object)"b")).isFalse();
        Assertions.assertThat((boolean)Predicates.equalOrNull((Object)"a", null)).isFalse();
    }

    @Test
    void equalsWithNull_predicate() {
        BiPredicate predicateMock = (BiPredicate)Mockito.mock(BiPredicate.class);
        Mockito.when((Object)predicateMock.test(ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertThat((boolean)Predicates.equalOrNull(null, null, (BiPredicate)predicateMock)).isTrue();
        Mockito.verifyZeroInteractions((Object[])new Object[]{predicateMock});
        Predicates.equalOrNull((Object)"a", (Object)"a", (BiPredicate)predicateMock);
        ((BiPredicate)Mockito.verify((Object)predicateMock, (VerificationMode)Mockito.times((int)1))).test(ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((Object)"a"));
        Predicates.equalOrNull((Object)"a", (Object)"b", (BiPredicate)predicateMock);
        ((BiPredicate)Mockito.verify((Object)predicateMock, (VerificationMode)Mockito.times((int)1))).test(ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((Object)"b"));
        Predicates.equalOrNull((Object)"b", (Object)"a", (BiPredicate)predicateMock);
        ((BiPredicate)Mockito.verify((Object)predicateMock, (VerificationMode)Mockito.times((int)1))).test(ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((Object)"b"));
        Mockito.clearInvocations((Object[])new BiPredicate[]{predicateMock});
        Predicates.equalOrNull(null, (Object)"b", (BiPredicate)predicateMock);
        Mockito.verifyZeroInteractions((Object[])new Object[]{predicateMock});
        Predicates.equalOrNull((Object)"a", null, (BiPredicate)predicateMock);
        Mockito.verifyZeroInteractions((Object[])new Object[]{predicateMock});
    }

    @Test
    void and_functions() {
        Function<Toto, String> function1 = Toto::getProp1;
        Function<Toto, Integer> function2 = Toto::getProp2;
        BiPredicate testInstance = Predicates.and((Function[])new Function[]{function1, function2});
        Assertions.assertThat((boolean)testInstance.test(new Toto("a", 1), new Toto("a", 1))).isTrue();
        Assertions.assertThat((boolean)testInstance.test(new Toto("a", 1), new Toto("a", 2))).isFalse();
        Assertions.assertThat((boolean)testInstance.test(new Toto("a", 1), new Toto("b", 1))).isFalse();
        Assertions.assertThat((boolean)testInstance.test(new Toto(null, 1), new Toto(null, 1))).isTrue();
        Assertions.assertThat((boolean)testInstance.test(new Toto("a", null), new Toto("a", null))).isTrue();
    }

    private class Toto {
        private final String prop1;
        private final Integer prop2;

        private Toto(String prop1, Integer prop2) {
            this.prop1 = prop1;
            this.prop2 = prop2;
        }

        public String getProp1() {
            return this.prop1;
        }

        public Integer getProp2() {
            return this.prop2;
        }
    }
}

