/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;

public abstract class SteppingIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> delegate;
    private long stepCount = 0L;
    private final long stepSize;

    public SteppingIterator(Iterable<? extends E> delegate, long stepSize) {
        this(delegate.iterator(), stepSize);
    }

    public SteppingIterator(Iterator<? extends E> delegate, long stepSize) {
        this.delegate = delegate;
        this.stepSize = stepSize;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.delegate.hasNext();
        if (this.stepCount == this.stepSize || !hasNext && this.stepCount != 0L) {
            this.onStep();
            this.stepCount = 0L;
        }
        return hasNext;
    }

    @Override
    public E next() {
        ++this.stepCount;
        return this.delegate.next();
    }

    public long getStepSize() {
        return this.stepSize;
    }

    public long getStepCount() {
        return this.stepCount;
    }

    protected abstract void onStep();

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

