/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class IdentityMap<K, V> {
    private final Map<Integer, V> delegate;

    public IdentityMap() {
        this.delegate = new HashMap<Integer, V>();
    }

    public IdentityMap(int capacity) {
        this.delegate = new HashMap<Integer, V>(capacity);
    }

    protected int hash(K key) {
        return System.identityHashCode(key);
    }

    public V put(K key, V value) {
        return this.delegate.put(this.hash(key), value);
    }

    public V get(K key) {
        return this.delegate.get(this.hash(key));
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(this.hash(key));
    }

    public V putIfAbsent(K key, V value) {
        return this.delegate.putIfAbsent(this.hash(key), value);
    }

    public V putIfAbsent(K key, Supplier<V> value) {
        return this.delegate.putIfAbsent(this.hash(key), value.get());
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)this.delegate.computeIfAbsent(this.hash(key), k -> mappingFunction.apply((Object)key));
    }

    public Collection<V> values() {
        return this.delegate.values();
    }

    public V remove(K key) {
        return this.delegate.remove(this.hash(key));
    }

    public void clear() {
        this.delegate.clear();
    }

    public int size() {
        return this.delegate.size();
    }

    public Map<Integer, V> getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMap that = (IdentityMap)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

