/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.sql;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.InvocationHandlerSupport;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.sql.ResultSetWrapper;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ResultSetWrapperTest {
    ResultSetWrapperTest() {
    }

    @Test
    void methodsInvocation_forwardToDelegateMethods() {
        ResultSet delegate = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetWrapper testInstance = new ResultSetWrapper(delegate);
        List dataSourceClassInheritance = Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(ResultSet.class, null)));
        dataSourceClassInheritance.add(0, ResultSet.class);
        MethodIterator methodIterator = new MethodIterator(dataSourceClassInheritance.iterator());
        Iterable methods = () -> methodIterator;
        int methodCount = 0;
        for (Method method : methods) {
            try {
                Object[] args = new Object[method.getParameterCount()];
                if (method.equals(Wrapper.class.getMethod("unwrap", Class.class)) || method.equals(Wrapper.class.getMethod("isWrapperFor", Class.class))) {
                    args[0] = CharSequence.class;
                } else {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Class<?> arg = parameterTypes[i];
                        args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                    }
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                Object delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new ResultSet[]{delegate});
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(196);
    }

    @Test
    void isWrapperFor() throws SQLException {
        ResultSet mock = (ResultSet)InvocationHandlerSupport.mock(ResultSet.class, (Class[])new Class[0]);
        ResultSetWrapper testInstance = new ResultSetWrapper(mock);
        Assertions.assertThat((boolean)testInstance.isWrapperFor(mock.getClass())).isTrue();
        Assertions.assertThat((boolean)testInstance.isWrapperFor(CharSequence.class)).isFalse();
    }

    @Test
    void unwrap() throws SQLException {
        ResultSet mock = (ResultSet)InvocationHandlerSupport.mock(ResultSet.class, (Class[])new Class[0]);
        ResultSetWrapper testInstance = new ResultSetWrapper(mock);
        Assertions.assertThat((Object)testInstance.unwrap(mock.getClass())).isSameAs((Object)mock);
        testInstance = new ResultSetWrapper((ResultSet)testInstance);
        Assertions.assertThat((Object)testInstance.unwrap(mock.getClass())).isSameAs((Object)mock);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
            CharSequence cfr_ignored_0 = (CharSequence)new ResultSetWrapper(null).unwrap(CharSequence.class);
        }).isInstanceOf(SQLException.class)).hasMessage("o.c.t.s.ResultSetWrapper cannot be unwrapped as j.l.CharSequence");
    }
}

