/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.TypeIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TypeIteratorTest {
    TypeIteratorTest() {
    }

    static Object[][] nextMethodsData() {
        return new Object[][]{{X.class, Arrays.asList((Object[])new Class[]{X.class, B.class, C.class, A.class})}, {Y.class, Arrays.asList((Object[])new Class[]{Y.class, D.class, X.class, B.class, C.class, A.class})}};
    }

    @ParameterizedTest
    @MethodSource(value={"nextMethodsData"})
    void next(Class clazz, List<Class> expectedClasses) {
        TypeIterator testInstance = new TypeIterator(clazz);
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo(expectedClasses);
    }

    @Test
    void next_stopClass() {
        TypeIterator testInstance = new TypeIterator(Z.class, X.class);
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new Class[]{Z.class, Y.class, D.class}));
    }

    @Test
    void nasNext_false() {
        TypeIterator testInstance = new TypeIterator(X.class, X.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
    }

    @Test
    void next_throwsNoSuchElementException() {
        TypeIterator testInstance = new TypeIterator(Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((TypeIterator)testInstance).next());
        testInstance = new TypeIterator(Object.class);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((TypeIterator)testInstance).next());
    }

    static interface D {
    }

    static interface C {
    }

    static interface B
    extends A {
    }

    static interface A {
    }

    static class Z
    extends Y {
        Z() {
        }
    }

    static class Y
    extends X
    implements D {
        Y() {
        }
    }

    static class X
    implements B,
    C {
        X() {
        }
    }
}

