/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.bean.Randomizer;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

public class StringAppenderTest {
    @Test
    public void testConstructor_array() {
        StringAppender testInstance = new StringAppender(new Object[]{"a", "b", "c", "d"});
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("abcd");
    }

    @Test
    public void testCat() {
        StringAppender testInstance = new StringAppender();
        testInstance.cat((Object)"a").cat((Object)"b").cat((Object)"c", (Object)"d").cat((Object)"e", (Object)"f", (Object)"g").cat(new Object[]{"h", "i", "j", "k", "l"}).cat((Iterable)Arrays.asList((Object[])new String[]{"m", "n", "o", "p"}));
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("abcdefghijklmnop");
    }

    @Test
    public void testCatIf() {
        StringAppender testInstance = new StringAppender();
        testInstance.catIf(true, new Object[]{"a"}).catIf(false, new Object[]{"b"}).catIf(true, new Object[]{"c", "d"}).catIf(false, new Object[]{"e", "f", "g"}).catIf(true, new Object[]{"h", "i", "j", "k", "l"});
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("acdhijkl");
    }

    @Test
    public void testCat_overriden() {
        StringAppender testInstance = new StringAppender(){

            public StringAppender cat(Object o) {
                return o instanceof Number ? this.cat("999") : super.cat(o);
            }
        };
        testInstance.cat((Object)Randomizer.INSTANCE.drawInt(), (Object)" expresso please !");
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("999 expresso please !");
        testInstance.cat((Object)" And ", (Object)Randomizer.INSTANCE.drawInt(), (Object)" chocolates !");
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("999 expresso please ! And 999 chocolates !");
        testInstance.catIf(true, new Object[]{" ", Randomizer.INSTANCE.drawInt(), " teas !"});
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("999 expresso please ! And 999 chocolates ! 999 teas !");
        testInstance.catAt(0, new Object[]{Randomizer.INSTANCE.drawInt()});
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("999999 expresso please ! And 999 chocolates ! 999 teas !");
        testInstance.wrap((Object)Randomizer.INSTANCE.drawInt(), (Object)Randomizer.INSTANCE.drawInt());
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("999999999 expresso please ! And 999 chocolates ! 999 teas !999");
    }

    @Test
    public void testWrap() {
        StringAppender testInstance = new StringAppender();
        testInstance.cat((Object)"a").wrap((Object)"#", (Object)"$");
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("#a$");
        testInstance = new StringAppender();
        testInstance.wrap((Object)"#", (Object)"$");
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("#$");
    }

    @Test
    public void testCcat() {
        StringAppender testInstance = new StringAppender();
        testInstance.ccat(new Object[]{"a", 1, "b", 2, ","});
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("a,1,b,2");
    }

    @Test
    public void testCcat_iterable() {
        StringAppender testInstance = new StringAppender();
        testInstance.ccat((Iterable)Arrays.asList((Object[])new Serializable[]{"a", Integer.valueOf(1), "b", Integer.valueOf(2)}), (Object)",");
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("a,1,b,2");
    }

    @Test
    public void testCcat_array() {
        StringAppender testInstance = new StringAppender();
        testInstance.ccat(new Object[]{"a", 1, "b", 2, "c", 3, "d", 4}, (Object)",");
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("a,1,b,2,c,3,d,4");
    }

    @Test
    public void testCcat_array_bounded() {
        StringAppender testInstance = new StringAppender();
        testInstance.ccat(new Object[]{"a", 1, "b", 2, "c", 3, "d", 4}, (Object)",", 2);
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("a,1");
        testInstance.getAppender().setLength(0);
        testInstance.ccat(new Object[]{"a", 1, "b", 2, "c", 3, "d", 4}, (Object)",", 5);
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("a,1,b,2,c");
    }

    @Test
    public void testCutTail() {
        StringAppender testInstance = new StringAppender();
        testInstance.cat((Object)"snake tail").cutTail(5);
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("snake");
    }

    @Test
    public void testCutHead() {
        StringAppender testInstance = new StringAppender();
        testInstance.cat((Object)"headache").cutHead(4);
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("ache");
    }

    @Test
    public void testCutAndInsert() {
        StringAppender testInstance = new StringAppender();
        testInstance.cat((Object)"headache").cutHead(4).catAt(0, new Object[]{"sstom"}).cutHead(1);
        Assertions.assertThat((String)testInstance.toString()).isEqualTo("stomache");
    }
}

