/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.PairIterator;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PairIteratorTest {
    @Test
    public void testHasNext() {
        PairIterator testInstance = new PairIterator((Iterable)Arrays.asList((Object[])new Integer[]{1, 2, 3}), (Iterable)Arrays.asList((Object[])new String[]{"a", "b"}));
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((Object)new Duo((Object)1, (Object)"a")).isEqualTo((Object)testInstance.next());
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((Object)new Duo((Object)2, (Object)"b")).isEqualTo((Object)testInstance.next());
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
    }

    public static Object[][] testNext_NoSuchElementExceptionData() {
        PairIterator startedIterator = new PairIterator((Iterable)Arrays.asList((Object[])new Integer[]{1}), (Iterable)Arrays.asList((Object[])new String[]{"a"}));
        startedIterator.next();
        return new Object[][]{{startedIterator}, {new PairIterator((Iterable)Arrays.asList((Object[])new Integer[]{1}), (Iterable)Arrays.asList((Object[])new Object[0]))}, {new PairIterator((Iterable)Arrays.asList((Object[])new Object[0]), (Iterable)Arrays.asList((Object[])new String[]{"a"}))}, {new PairIterator((Iterable)Arrays.asList((Object[])new Object[0]), (Iterable)Arrays.asList((Object[])new Object[0]))}};
    }

    @ParameterizedTest
    @MethodSource(value={"testNext_NoSuchElementExceptionData"})
    public void testNext_NoSuchElementException(PairIterator<Integer, String> testInstance) {
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> testInstance.next());
    }

    @Test
    public void testRemove() {
        List integers = Arrays.asList((Object[])new Integer[]{1, 2, 3});
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        PairIterator testInstance = new PairIterator((Iterable)integers, (Iterable)strings);
        testInstance.hasNext();
        testInstance.next();
        testInstance.remove();
        Assertions.assertThat((List)Arrays.asList((Object[])new Integer[]{2, 3})).isEqualTo((Object)integers);
        Assertions.assertThat((List)Arrays.asList((Object[])new String[]{"b"})).isEqualTo((Object)strings);
    }

    @Test
    public void testInfiniteIterator() {
        List integers = Arrays.asList((Object[])new Integer[]{1, 2, 3});
        List strings = Arrays.asList((Object[])new String[]{"a"});
        PairIterator testInstance = new PairIterator(integers.iterator(), (Iterator)new PairIterator.InfiniteIterator(strings.iterator()));
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((Object)new Duo((Object)1, (Object)"a")).isEqualTo((Object)testInstance.next());
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((Object)new Duo((Object)2, null)).isEqualTo((Object)testInstance.next());
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((Object)new Duo((Object)3, null)).isEqualTo((Object)testInstance.next());
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
    }
}

