/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.exception;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.ReadOnlyIterator;

public interface Exceptions {
    public static RuntimeException asRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    public static <T> T findExceptionInCauses(Throwable t, Class<T> throwableClass) {
        return (T)Exceptions.findExceptionInCauses(t, new ClassExceptionFilter<T>(throwableClass));
    }

    public static <T> T findExceptionInCauses(Throwable t, Class<T> throwableClass, String message) {
        return (T)Exceptions.findExceptionInCauses(t, new ClassAndMessageExceptionFilter<T>(throwableClass, message));
    }

    public static <T> T findExceptionInCauses(Throwable t, Class<T> throwableClass, Predicate<String> messageAccepter) {
        return (T)Exceptions.findExceptionInCauses(t, new ClassAndMessageExceptionFilter<T>(throwableClass, messageAccepter));
    }

    public static Throwable findExceptionInCauses(Throwable t, ExceptionFilter filter) {
        return Iterables.stream(new ExceptionCauseIterator(t)).filter(filter::accept).findAny().orElse(null);
    }

    public static class ClassAndMessageExceptionFilter<T>
    extends ClassExceptionFilter<T> {
        private final Predicate<String> messageAccepter;

        public ClassAndMessageExceptionFilter(Class<T> c, String message) {
            super(c);
            this.messageAccepter = message::equalsIgnoreCase;
        }

        public ClassAndMessageExceptionFilter(Class<T> c, Predicate<String> messageAccepter) {
            super(c);
            this.messageAccepter = messageAccepter;
        }

        @Override
        public boolean accept(Throwable t) {
            return super.accept(t) && this.messageAccepter.test(t.getMessage());
        }
    }

    public static class ClassExceptionFilter<T>
    implements ExceptionFilter {
        private final Class<T> targetClass;

        public ClassExceptionFilter(Class<T> c) {
            this.targetClass = c;
        }

        @Override
        public boolean accept(Throwable t) {
            return this.targetClass.isAssignableFrom(t.getClass());
        }
    }

    public static interface ExceptionFilter {
        public boolean accept(Throwable var1);
    }

    public static class ExceptionCauseIterator
    extends ReadOnlyIterator<Throwable> {
        private Throwable currentThrowable;
        private boolean hasNext = false;

        public ExceptionCauseIterator(Throwable throwable) {
            this.currentThrowable = throwable;
        }

        @Override
        public boolean hasNext() {
            this.hasNext = this.currentThrowable != null;
            return this.hasNext;
        }

        @Override
        public Throwable next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Throwable next = this.currentThrowable;
            this.currentThrowable = this.currentThrowable.getCause();
            return next;
        }
    }
}

