/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.StreamSplitter;
import org.junit.jupiter.api.Test;

class StreamSplitterTest {
    StreamSplitterTest() {
    }

    @Test
    void split() {
        Stream menuStream = Dish.MENU.stream();
        HashSet veggyDishes = new HashSet();
        HashSet healthyDishes = new HashSet();
        HashSet junkFood = new HashSet();
        new StreamSplitter(menuStream).dispatch(Dish::isVegetarian, veggyDishes::add).dispatch(dish -> dish.getCalories() < 400, healthyDishes::add).dispatch(dish -> dish.getCalories() > 600, junkFood::add).split();
        Assertions.assertThat(veggyDishes).containsExactlyInAnyOrder((Object[])new Dish[]{Dish.FRENCH_FRIES, Dish.SEASON_FRUIT, Dish.RICE, Dish.PIZZA});
        Assertions.assertThat(healthyDishes).containsExactlyInAnyOrder((Object[])new Dish[]{Dish.SEASON_FRUIT, Dish.RICE});
        Assertions.assertThat(junkFood).containsExactlyInAnyOrder((Object[])new Dish[]{Dish.BEEF, Dish.PORK});
    }

    static class Dish {
        private final String name;
        private final boolean vegetarian;
        private final int calories;
        private final Type type;
        public static final Dish PORK = new Dish("pork", false, 800, Type.MEAT);
        public static final Dish BEEF = new Dish("beef", false, 700, Type.MEAT);
        public static final Dish CHICKEN = new Dish("chicken", false, 400, Type.MEAT);
        public static final Dish FRENCH_FRIES = new Dish("french fries", true, 530, Type.VEGETABLE);
        public static final Dish RICE = new Dish("rice", true, 350, Type.VEGETABLE);
        public static final Dish SEASON_FRUIT = new Dish("season fruit", true, 120, Type.FRUIT);
        public static final Dish PIZZA = new Dish("pizza", true, 550, Type.MIX);
        public static final Dish PRAWNS = new Dish("prawns", false, 400, Type.FISH);
        public static final Dish SALMON = new Dish("salmon", false, 450, Type.FISH);
        public static final List<Dish> MENU = Arrays.asList((Object[])new Dish[]{PORK, BEEF, CHICKEN, FRENCH_FRIES, RICE, SEASON_FRUIT, PIZZA, PRAWNS, SALMON});

        private Dish(String name, boolean vegetarian, int calories, Type type) {
            this.name = name;
            this.vegetarian = vegetarian;
            this.calories = calories;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVegetarian() {
            return this.vegetarian;
        }

        public int getCalories() {
            return this.calories;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public static enum Type {
            MEAT,
            FISH,
            FRUIT,
            VEGETABLE,
            MIX;

        }
    }
}

