/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class InterfaceIteratorTest {
    public static Object[][] testNextData() {
        return new Object[][]{{Object.class, Arrays.asList((Object[])new Object[0])}, {String.class, Arrays.asList((Object[])new Class[]{Serializable.class, Comparable.class, CharSequence.class})}, {RuntimeException.class, Arrays.asList((Object[])new Class[]{Serializable.class})}, {ByteArrayInputStream.class, Arrays.asList((Object[])new Class[]{Closeable.class, AutoCloseable.class})}, {StringBuffer.class, Arrays.asList((Object[])new Class[]{Serializable.class, CharSequence.class, Appendable.class, CharSequence.class})}, {ArrayList.class, Arrays.asList((Object[])new Class[]{List.class, RandomAccess.class, Cloneable.class, Serializable.class, Collection.class, Iterable.class, List.class, Collection.class, Iterable.class, Collection.class, Iterable.class})}};
    }

    @ParameterizedTest
    @MethodSource(value={"testNextData"})
    public void testNext(Class clazz, List<Class> expectedInterfaces) {
        InterfaceIterator testInstance = new InterfaceIterator(clazz);
        Assertions.assertThat((List)Iterables.collectToList(() -> testInstance, Function.identity())).isEqualTo(expectedInterfaces);
    }

    @Test
    public void testNext_throwsNoSuchElementException() {
        InterfaceIterator testInstance = new InterfaceIterator(RuntimeException.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InterfaceIterator)testInstance).next());
        testInstance = new InterfaceIterator(RuntimeException.class);
        testInstance.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InterfaceIterator)testInstance).next());
        testInstance = new InterfaceIterator(Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InterfaceIterator)testInstance).next());
        testInstance = new InterfaceIterator(Object.class);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InterfaceIterator)testInstance).next());
    }
}

