/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.junit.jupiter.api.Test;

class KeepOrderMapTest {
    KeepOrderMapTest() {
    }

    @Test
    void orderIsKept() {
        KeepOrderMap testInstance = new KeepOrderMap();
        testInstance.put((Object)"b", (Object)"bbb");
        testInstance.put((Object)"a", (Object)"aaa");
        testInstance.put((Object)"c", (Object)"ccc");
        List result = testInstance.entrySet().stream().map(e -> new Duo(e.getKey(), e.getValue())).collect(Collectors.toList());
        Assertions.assertThat(result).isEqualTo((Object)Arrays.asList((Object[])new Duo[]{new Duo((Object)"b", (Object)"bbb"), new Duo((Object)"a", (Object)"aaa"), new Duo((Object)"c", (Object)"ccc")}));
    }

    @Test
    void removeAt() {
        KeepOrderMap testInstance = new KeepOrderMap();
        testInstance.put((Object)"b", (Object)"bbb");
        testInstance.put((Object)"a", (Object)"aaa");
        testInstance.put((Object)"c", (Object)"ccc");
        testInstance.removeAt(1);
        Assertions.assertThat((String)((String)testInstance.get((Object)"a"))).isNull();
        List result = testInstance.entrySet().stream().map(e -> new Duo(e.getKey(), e.getValue())).collect(Collectors.toList());
        Assertions.assertThat(result).isEqualTo((Object)Arrays.asList((Object[])new Duo[]{new Duo((Object)"b", (Object)"bbb"), new Duo((Object)"c", (Object)"ccc")}));
    }

    @Test
    void getAt() {
        KeepOrderMap testInstance = new KeepOrderMap();
        testInstance.put((Object)"b", (Object)"bbb");
        testInstance.put((Object)"a", (Object)"aaa");
        testInstance.put((Object)"c", (Object)"ccc");
        Assertions.assertThat((String)((String)testInstance.getAt(1).getKey())).isEqualTo("a");
        Assertions.assertThat((String)((String)testInstance.getAt(1).getValue())).isEqualTo("aaa");
    }
}

