/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.codefilarete.tool.collection.ReadOnlyCollection;
import org.codefilarete.tool.collection.ReadOnlyIterator;

public class ReadOnlyList<E>
extends ReadOnlyCollection<E, List<E>>
implements List<E> {
    public ReadOnlyList() {
        this(new ArrayList());
    }

    public ReadOnlyList(int initialCapacity) {
        this(new ArrayList(initialCapacity));
    }

    public ReadOnlyList(List<? extends E> list) {
        super(list);
    }

    @Override
    public E get(int index) {
        return ((List)this.delegate).get(index);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ReadOnlyListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ReadOnlyList(((List)this.delegate).subList(fromIndex, toIndex));
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.delegate).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.delegate).lastIndexOf(o);
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    class ReadOnlyListIterator
    extends ReadOnlyIterator<E>
    implements ListIterator<E> {
        private final ListIterator<? extends E> delegateIterator;

        ReadOnlyListIterator(int index) {
            this.delegateIterator = ((List)ReadOnlyList.this.delegate).listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.delegateIterator.hasNext();
        }

        @Override
        public E next() {
            return this.delegateIterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegateIterator.hasPrevious();
        }

        @Override
        public E previous() {
            return this.delegateIterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.delegateIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegateIterator.previousIndex();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.delegateIterator.forEachRemaining(action);
        }

        @Override
        public final void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

