/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.FilteringIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Predicates;
import org.junit.jupiter.api.Test;

class FilteringIteratorTest {
    FilteringIteratorTest() {
    }

    @Test
    void filter() {
        FilteringIterator testInstance = new FilteringIterator(Arrays.asList((Object[])new String[]{"a", null, "b", "c", "b"}).iterator(), Predicates.not("b"::equals));
        List copy = Iterables.copy((Iterator)testInstance);
        Assertions.assertThat((List)copy).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", null, "c"}));
        testInstance = new FilteringIterator(Arrays.asList((Object[])new String[]{"a", null, "b", "c", "b"}).iterator(), Objects::nonNull);
        copy = Iterables.copy((Iterator)testInstance);
        Assertions.assertThat((List)copy).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b", "c", "b"}));
    }

    @Test
    void filterWorksAtVeryFirstStep() {
        FilteringIterator testInstance = new FilteringIterator(Arrays.asList((Object[])new String[]{"a", null, "b", "c", "b"}).iterator(), Predicates.not("b"::equals));
        testInstance.hasNext();
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("a");
        testInstance = new FilteringIterator(Arrays.asList((Object[])new String[]{"a", null, "b", "c", "b"}).iterator(), Objects::nonNull);
        testInstance.hasNext();
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("a");
        testInstance.hasNext();
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("b");
    }

    @Test
    void remove() {
        FilteringIterator testInstance = new FilteringIterator(Arrays.asList((Object[])new String[]{"a", null, "b", "c", "b"}).iterator(), Predicates.not("b"::equals));
        testInstance.hasNext();
        testInstance.next();
        testInstance.hasNext();
        testInstance.next();
        testInstance.remove();
        List copy = Iterables.copy((Iterator)testInstance);
        Assertions.assertThat((List)copy).isEqualTo((Object)Arrays.asList((Object[])new String[]{"c"}));
    }
}

