/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.FilteringIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.collection.ReadOnlyList;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ReadOnlyListTest {
    private static final Set<Method> MUTATING_METHODS = new HashSet<Method>();
    private static final Set<Method> DEFAULT_METHODS = new HashSet<Method>();
    private static final Set<Method> EQUALS_HASHCODE_METHODS = new HashSet<Method>();
    private static final Set<Method> ITERATOR_MUTATING_METHODS = new HashSet<Method>();

    ReadOnlyListTest() {
    }

    @Test
    void methodsInvokeDelegateMethods() {
        List delegate = (List)Mockito.mock(List.class);
        ReadOnlyList testInstance = new ReadOnlyList(delegate);
        List listClassInheritance = Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(List.class, null)));
        listClassInheritance.add(0, List.class);
        MethodIterator methodInHierarchyIterator = new MethodIterator(listClassInheritance.iterator());
        FilteringIterator nonMutatingMethodsIterator = new FilteringIterator((Iterator)methodInHierarchyIterator, m -> !MUTATING_METHODS.contains(m) && !EQUALS_HASHCODE_METHODS.contains(m) && !DEFAULT_METHODS.contains(m));
        Iterable methods = () -> nonMutatingMethodsIterator;
        int methodCount = 0;
        for (Method method : methods) {
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                switch (method.getName()) {
                    case "iterator": {
                        ((List)Mockito.verify((Object)delegate)).listIterator(ArgumentMatchers.eq((int)0));
                        break;
                    }
                    case "spliterator": {
                        ((List)Mockito.verify((Object)delegate)).spliterator();
                        break;
                    }
                    case "listIterator": {
                        ((List)Mockito.verify((Object)delegate)).listIterator(ArgumentMatchers.eq((int)0));
                        Assertions.assertThat((boolean)(invocationResult instanceof ReadOnlyIterator)).isTrue();
                        break;
                    }
                    default: {
                        Object delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                        if (method.equals(List.class.getMethod("subList", Integer.TYPE, Integer.TYPE))) {
                            delegateResult = new ReadOnlyList();
                        }
                        Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                    }
                }
                Mockito.clearInvocations((Object[])new List[]{delegate});
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(24);
    }

    @Test
    void readOnlyMethodsThrowException() {
        List delegate = (List)Mockito.mock(List.class);
        Condition hasUnsupportedOperationExceptionInTrace = new Condition(thrownException -> Exceptions.findExceptionInCauses((Throwable)thrownException, UnsupportedOperationException.class) != null, "exception stack contains " + UnsupportedOperationException.class.getSimpleName(), new Object[0]);
        ReadOnlyList testInstance = new ReadOnlyList(delegate);
        for (Method method : MUTATING_METHODS) {
            Object[] args = new Object[method.getParameterCount()];
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> arg = parameterTypes[i];
                args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
            }
            Assertions.assertThatThrownBy(() -> {
                try {
                    method.invoke((Object)testInstance, args);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
                }
            }).satisfies(hasUnsupportedOperationExceptionInTrace);
        }
    }

    @Test
    void listIteratorMethodsInvokeDelegateMethods() {
        List list = (List)Mockito.mock(List.class);
        ListIterator delegate = (ListIterator)Mockito.mock(ListIterator.class);
        Mockito.when(list.listIterator(ArgumentMatchers.eq((int)0))).thenReturn((Object)delegate);
        ListIterator testInstance = new ReadOnlyList(list).listIterator();
        List listClassInheritance = Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(ListIterator.class, null)));
        listClassInheritance.add(0, ListIterator.class);
        MethodIterator methodInHierarchyIterator = new MethodIterator(listClassInheritance.iterator());
        FilteringIterator nonMutatingMethodsIterator = new FilteringIterator((Iterator)methodInHierarchyIterator, m -> !ITERATOR_MUTATING_METHODS.contains(m) && !EQUALS_HASHCODE_METHODS.contains(m) && !DEFAULT_METHODS.contains(m));
        Iterable methods = () -> nonMutatingMethodsIterator;
        int methodCount = 0;
        for (Method method : methods) {
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                Object delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new ListIterator[]{delegate});
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(9);
    }

    @Test
    void listIteratorReadOnlyMethodsThrowException() {
        List delegate = (List)Mockito.mock(List.class);
        Condition hasUnsupportedOperationExceptionInTrace = new Condition(thrownException -> Exceptions.findExceptionInCauses((Throwable)thrownException, UnsupportedOperationException.class) != null, "exception stack contains " + UnsupportedOperationException.class.getSimpleName(), new Object[0]);
        ListIterator testInstance = new ReadOnlyList(delegate).listIterator();
        for (Method method : ITERATOR_MUTATING_METHODS) {
            Object[] args = new Object[method.getParameterCount()];
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> arg = parameterTypes[i];
                args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
            }
            Assertions.assertThatThrownBy(() -> {
                try {
                    method.invoke((Object)testInstance, args);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
                }
            }).satisfies(hasUnsupportedOperationExceptionInTrace);
        }
    }

    static {
        try {
            MUTATING_METHODS.add(List.class.getMethod("set", Integer.TYPE, Object.class));
            MUTATING_METHODS.add(List.class.getMethod("add", Object.class));
            MUTATING_METHODS.add(List.class.getMethod("add", Integer.TYPE, Object.class));
            MUTATING_METHODS.add(List.class.getMethod("remove", Integer.TYPE));
            MUTATING_METHODS.add(List.class.getMethod("remove", Object.class));
            MUTATING_METHODS.add(List.class.getMethod("addAll", Collection.class));
            MUTATING_METHODS.add(List.class.getMethod("addAll", Integer.TYPE, Collection.class));
            MUTATING_METHODS.add(List.class.getMethod("removeAll", Collection.class));
            MUTATING_METHODS.add(List.class.getMethod("retainAll", Collection.class));
            MUTATING_METHODS.add(List.class.getMethod("replaceAll", UnaryOperator.class));
            MUTATING_METHODS.add(List.class.getMethod("sort", Comparator.class));
            MUTATING_METHODS.add(List.class.getMethod("clear", new Class[0]));
            MUTATING_METHODS.add(Collection.class.getMethod("add", Object.class));
            MUTATING_METHODS.add(Collection.class.getMethod("addAll", Collection.class));
            MUTATING_METHODS.add(Collection.class.getMethod("remove", Object.class));
            MUTATING_METHODS.add(Collection.class.getMethod("removeAll", Collection.class));
            MUTATING_METHODS.add(Collection.class.getMethod("retainAll", Collection.class));
            MUTATING_METHODS.add(Collection.class.getMethod("clear", new Class[0]));
            DEFAULT_METHODS.add(Collection.class.getMethod("stream", new Class[0]));
            DEFAULT_METHODS.add(Collection.class.getMethod("parallelStream", new Class[0]));
            DEFAULT_METHODS.add(Collection.class.getMethod("removeIf", Predicate.class));
            DEFAULT_METHODS.add(Iterable.class.getMethod("forEach", Consumer.class));
            EQUALS_HASHCODE_METHODS.add(List.class.getMethod("equals", Object.class));
            EQUALS_HASHCODE_METHODS.add(List.class.getMethod("hashCode", new Class[0]));
            EQUALS_HASHCODE_METHODS.add(Collection.class.getMethod("equals", Object.class));
            EQUALS_HASHCODE_METHODS.add(Collection.class.getMethod("hashCode", new Class[0]));
            ITERATOR_MUTATING_METHODS.add(ListIterator.class.getMethod("set", Object.class));
            ITERATOR_MUTATING_METHODS.add(ListIterator.class.getMethod("add", Object.class));
            ITERATOR_MUTATING_METHODS.add(ListIterator.class.getMethod("remove", new Class[0]));
            ITERATOR_MUTATING_METHODS.add(Iterator.class.getMethod("remove", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

