/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codefilarete.tool.collection.ArrayIterator;

public class IteratorIterator<E>
implements Iterator<E> {
    private final Iterator<Iterable<E>> iterables;
    private Iterator<E> currentIterator;

    @SafeVarargs
    public IteratorIterator(final Iterator<E> ... iterables) {
        this(new Iterator<Iterable<E>>(){
            private final Iterator<Iterator<E>> delegate;
            {
                this.delegate = new ArrayIterator<Iterator>(iterables);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Iterable<E> next() {
                return this.delegate::next;
            }
        });
    }

    @SafeVarargs
    public IteratorIterator(Iterable<E> ... iterables) {
        this((Iterator<Iterable<E>>)new ArrayIterator<Iterable<E>>(iterables));
    }

    public IteratorIterator(Iterable<Iterable<E>> iterables) {
        this(iterables.iterator());
    }

    public IteratorIterator(Iterator<Iterable<E>> iterables) {
        this.iterables = iterables;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            boolean found = false;
            while (!found) {
                if (this.iterables.hasNext()) {
                    this.currentIterator = this.iterables.next().iterator();
                    found = this.currentIterator.hasNext();
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }
}

