/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.ReflectionsTest;
import org.codefilarete.tool.reflect.MemberPrinter;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MemberPrinterTest {
    @Test
    public void toStringClass() throws ClassNotFoundException {
        MemberPrinter testInstance = MemberPrinter.FLATTEN_PACKAGE_PRINTER;
        Assertions.assertThat((String)testInstance.toString(String.class)).isEqualTo("j.l.String");
        Assertions.assertThat((String)testInstance.toString(Collection.class)).isEqualTo("j.u.Collection");
        Assertions.assertThat((String)testInstance.toString(ReflectionsTest.class)).isEqualTo("o.c.t.ReflectionsTest");
        Assertions.assertThat((String)testInstance.toString(Class.forName("TopPackageLevelClass"))).isEqualTo("TopPackageLevelClass");
        Assertions.assertThat((String)testInstance.toString(Boolean.TYPE)).isEqualTo("boolean");
        Assertions.assertThat((String)testInstance.toString(Boolean.TYPE)).isEqualTo("boolean");
        Assertions.assertThat((String)testInstance.toString(Void.TYPE)).isEqualTo("void");
        Assertions.assertThat((String)testInstance.toString(Comparable[].class)).isEqualTo("j.l.Comparable[]");
        Assertions.assertThat((String)testInstance.toString(Map.Entry.class)).isEqualTo("j.u.Map$Entry");
    }

    private static Object[][] toStringConstructor() {
        Constructor stringWithStringArgConstructor = Reflections.getConstructor(String.class, (Class[])new Class[]{String.class});
        Constructor stringWithCharIntIntArgsConstructor = Reflections.getConstructor(String.class, (Class[])new Class[]{char[].class, Integer.TYPE, Integer.TYPE});
        return new Object[][]{{stringWithStringArgConstructor, "j.l.String(j.l.String)", "java.lang.String(java.lang.String)"}, {stringWithCharIntIntArgsConstructor, "j.l.String(char[], int, int)", "java.lang.String(char[], int, int)"}};
    }

    @ParameterizedTest
    @MethodSource
    public void toStringConstructor(Constructor constructor, String expectedFlattenPkgePrint, String expectedFullPkgePrint) {
        Assertions.assertThat((String)MemberPrinter.FLATTEN_PACKAGE_PRINTER.toString(constructor)).isEqualTo(expectedFlattenPkgePrint);
        Assertions.assertThat((String)MemberPrinter.FULL_PACKAGE_PRINTER.toString(constructor)).isEqualTo(expectedFullPkgePrint);
    }

    private static Object[][] toStringMethod() {
        Method equalsIgnoreCaseMethod = Reflections.getMethod(String.class, (String)"equalsIgnoreCase", (Class[])new Class[]{String.class});
        Method substringMethod = Reflections.getMethod(String.class, (String)"substring", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        return new Object[][]{{equalsIgnoreCaseMethod, "j.l.String.equalsIgnoreCase(j.l.String)", "java.lang.String.equalsIgnoreCase(java.lang.String)"}, {substringMethod, "j.l.String.substring(int, int)", "java.lang.String.substring(int, int)"}};
    }

    @ParameterizedTest
    @MethodSource
    public void toStringMethod(Method method, String expectedFlattenPkgePrint, String expectedFullPkgePrint) {
        Assertions.assertThat((String)MemberPrinter.FLATTEN_PACKAGE_PRINTER.toString(method)).isEqualTo(expectedFlattenPkgePrint);
        Assertions.assertThat((String)MemberPrinter.FULL_PACKAGE_PRINTER.toString(method)).isEqualTo(expectedFullPkgePrint);
    }

    @ParameterizedTest
    @MethodSource(value={"toStringConstructor", "toStringMethod"})
    public void toStringExecutable(Executable executable, String expectedFlattenPkgePrint, String expectedFullPkgePrint) {
        Assertions.assertThat((String)MemberPrinter.FLATTEN_PACKAGE_PRINTER.toString(executable)).isEqualTo(expectedFlattenPkgePrint);
        Assertions.assertThat((String)MemberPrinter.FULL_PACKAGE_PRINTER.toString(executable)).isEqualTo(expectedFullPkgePrint);
    }

    @Test
    public void toStringField() {
        Field valueField = Reflections.getField(String.class, (String)"value");
        Assertions.assertThat((String)MemberPrinter.FLATTEN_PACKAGE_PRINTER.toString(valueField)).isEqualTo("j.l.String.value");
        Assertions.assertThat((String)MemberPrinter.FULL_PACKAGE_PRINTER.toString(valueField)).isEqualTo("java.lang.String.value");
        Field defaultsPropertiesField = Reflections.getField(Properties.class, (String)"defaults");
        Assertions.assertThat((String)MemberPrinter.FLATTEN_PACKAGE_PRINTER.toString(defaultsPropertiesField)).isEqualTo("j.u.Properties.defaults");
        Assertions.assertThat((String)MemberPrinter.FULL_PACKAGE_PRINTER.toString(defaultsPropertiesField)).isEqualTo("java.util.Properties.defaults");
    }

    @Test
    public void toStringClass_wellKnowPackage() throws ClassNotFoundException {
        MemberPrinter testInstance = MemberPrinter.WELL_KNOWN_FLATTEN_PACKAGE_PRINTER;
        Assertions.assertThat((String)testInstance.toString(String.class)).isEqualTo("String");
        Assertions.assertThat((String)testInstance.toString(Collection.class)).isEqualTo("Collection");
        Assertions.assertThat((String)testInstance.toString(ReflectionsTest.class)).isEqualTo("o.c.t.ReflectionsTest");
        Assertions.assertThat((String)testInstance.toString(Class.forName("TopPackageLevelClass"))).isEqualTo("TopPackageLevelClass");
        Assertions.assertThat((String)testInstance.toString(Boolean.TYPE)).isEqualTo("boolean");
        Assertions.assertThat((String)testInstance.toString(Boolean.TYPE)).isEqualTo("boolean");
        Assertions.assertThat((String)testInstance.toString(Void.TYPE)).isEqualTo("void");
    }
}

