/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.bean.Objects;

public abstract class Strings {
    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static <C extends CharSequence> C preventEmpty(C charSequence, C replacement) {
        return Strings.isEmpty(charSequence) ? replacement : charSequence;
    }

    public static String capitalize(CharSequence cs) {
        return (String)Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(CharSequence cs) {
                return Character.toUpperCase(cs.charAt(0)) + cs.subSequence(1, cs.length()).toString();
            }
        });
    }

    public static String uncapitalize(CharSequence cs) {
        return (String)Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(CharSequence cs) {
                return Character.toLowerCase(cs.charAt(0)) + cs.subSequence(1, cs.length()).toString();
            }
        });
    }

    public static StringBuilder repeat(int count, CharSequence s, String ... prebuiltStrings) {
        StringBuilder result = new StringBuilder(count * s.length());
        Strings.repeat(result, count, s, (CharSequence[])prebuiltStrings);
        return result;
    }

    public static StringBuilder repeat(StringBuilder result, int count, CharSequence s, CharSequence ... prebuiltStrings) {
        result.ensureCapacity(result.length() + count * s.length());
        int remainer = count;
        for (CharSequence snippet : prebuiltStrings) {
            int snippetLength = snippet.length();
            int snippetCount = remainer / snippetLength;
            for (int i = 0; i < snippetCount; ++i) {
                result.append(snippet);
            }
            remainer %= snippetLength;
        }
        for (int i = 0; i < remainer; ++i) {
            result.append(s);
        }
        return result;
    }

    public static List<String> split(String stringToBeSplit, char separator, boolean keepSeparatorInResult) {
        int substringPadding;
        ArrayList<String> result = new ArrayList<String>();
        int separatorIndex = stringToBeSplit.indexOf(separator);
        int previousSeparatorIndex = 0;
        int n = substringPadding = keepSeparatorInResult ? 1 : 0;
        while (separatorIndex != -1) {
            result.add(stringToBeSplit.substring(previousSeparatorIndex, separatorIndex + substringPadding));
            previousSeparatorIndex = separatorIndex + 1;
            separatorIndex = stringToBeSplit.indexOf(separator, previousSeparatorIndex);
        }
        if (previousSeparatorIndex < stringToBeSplit.length()) {
            result.add(stringToBeSplit.substring(previousSeparatorIndex));
        }
        return result;
    }

    public static CharSequence head(@Nullable CharSequence cs, final @Nonnegative int headSize) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                return cs.subSequence(0, Math.min(cs.length(), headSize));
            }
        });
    }

    public static CharSequence head(@Nullable String cs, final String untilIncluded) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                int index = ((String)cs).indexOf(untilIncluded);
                return cs.subSequence(0, Math.min(cs.length(), Objects.fallback(index, -1, 0)));
            }
        });
    }

    public static CharSequence cutHead(@Nullable CharSequence cs, final @Nonnegative int headSize) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                return cs.subSequence(Math.min(headSize, cs.length()), cs.length());
            }
        });
    }

    public static CharSequence tail(@Nullable CharSequence cs, final @Nonnegative int tailSize) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                return cs.subSequence(Math.max(0, cs.length() - tailSize), cs.length());
            }
        });
    }

    public static CharSequence tail(@Nullable CharSequence cs, final String afterLast) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                return cs.subSequence(Math.max(0, cs.toString().lastIndexOf(afterLast) + afterLast.length()), cs.length());
            }
        });
    }

    public static CharSequence cutTail(@Nullable CharSequence cs, final @Nonnegative int tailSize) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                return cs.subSequence(0, Strings.preventNegative(cs.length() - tailSize));
            }
        });
    }

    public static CharSequence ellipsis(@Nullable CharSequence cs, final @Nonnegative int length) {
        return Strings.doWithDelegate(cs, new DefaultNullOrEmptyDelegate(){

            @Override
            public CharSequence onNotNullNotEmpty(@Nonnull CharSequence cs) {
                if (cs.length() > length) {
                    return cs.subSequence(0, length) + "...";
                }
                return cs;
            }
        });
    }

    private static int preventNegative(int i) {
        return Math.max(i, 0);
    }

    private static CharSequence doWithDelegate(@Nullable CharSequence cs, INullOrEmptyDelegate emptyDelegate) {
        if (cs == null) {
            return emptyDelegate.onNull();
        }
        if (cs.length() == 0) {
            return emptyDelegate.onEmpty();
        }
        return emptyDelegate.onNotNullNotEmpty(cs);
    }

    @SafeVarargs
    public static <O> String footPrint(O object, Function<O, ?> ... printableProperties) {
        StringAppender result = new StringAppender();
        for (Function<O, ?> printableProperty : printableProperties) {
            result.cat(printableProperty.apply(object), (Object)", ");
        }
        return result.cutTail(2).toString();
    }

    private Strings() {
    }

    private static abstract class DefaultNullOrEmptyDelegate
    implements INullOrEmptyDelegate {
        private DefaultNullOrEmptyDelegate() {
        }

        @Override
        public CharSequence onNull() {
            return null;
        }

        @Override
        public CharSequence onEmpty() {
            return "";
        }
    }

    private static interface INullOrEmptyDelegate {
        public CharSequence onNull();

        public CharSequence onEmpty();

        public CharSequence onNotNullNotEmpty(@Nonnull CharSequence var1);
    }
}

