/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.function.ThrowingConsumer;
import org.codefilarete.tool.function.ThrowingFunction;
import org.codefilarete.tool.function.ThrowingRunnable;
import org.codefilarete.tool.function.ThrowingSupplier;

public class ThreadLocals {
    public static <T> void doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, Runnable runnable) {
        ThreadLocals.doWithThreadLocal(threadLocal, factory, runnable::run);
    }

    public static <T, E extends Throwable> void doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, ThrowingRunnable<E> runnable) throws E {
        ThreadLocals.doWithThreadLocal(threadLocal, factory, (T t) -> {
            runnable.run();
            return null;
        });
    }

    public static <T> void doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, Consumer<T> runnable) {
        ThreadLocals.doWithThreadLocal(threadLocal, factory, runnable::accept);
    }

    public static <T, E extends Throwable> void doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, ThrowingConsumer<T, E> runnable) throws E {
        ThreadLocals.doWithThreadLocal(threadLocal, factory, (T t) -> {
            runnable.accept(t);
            return null;
        });
    }

    public static <T, O> O doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, Supplier<O> runnable) {
        return (O)ThreadLocals.doWithThreadLocal(threadLocal, factory, runnable::get);
    }

    public static <T, O, E extends Throwable> O doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, ThrowingSupplier<O, E> runnable) throws E {
        return (O)ThreadLocals.doWithThreadLocal(threadLocal, factory, (T t) -> runnable.get());
    }

    public static <T, O> O doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, Function<T, O> runnable) {
        return (O)ThreadLocals.doWithThreadLocal(threadLocal, factory, runnable::apply);
    }

    public static <T, O, E extends Throwable> O doWithThreadLocal(ThreadLocal<T> threadLocal, Supplier<T> factory, ThrowingFunction<T, O, E> runnable) throws E {
        T value = threadLocal.get();
        if (value == null) {
            value = factory.get();
            threadLocal.set(value);
        }
        try (AutoRemoveThreadLocal<T> ignored = new AutoRemoveThreadLocal<T>(threadLocal);){
            O o = runnable.apply(value);
            return o;
        }
    }

    public static class AutoRemoveThreadLocal<T>
    implements AutoCloseable,
    Supplier<T>,
    Hanger<T> {
        private final ThreadLocal<T> delegate;

        public AutoRemoveThreadLocal(ThreadLocal<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return this.delegate.get();
        }

        @Override
        public void set(T value) {
            this.delegate.set(value);
        }

        @Override
        public void close() {
            this.delegate.remove();
        }
    }
}

