/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.function;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.tool.Reflections;

public class Functions {
    public static <T> Function<T, Boolean> toFunction(Predicate<T> predicate) {
        return predicate::test;
    }

    public static <I, O> Function<I, O> toFunction(Method getter) {
        if (getter.getParameterCount() > 0) {
            throw new IllegalArgumentException("Method is expected to have no argument but has one : " + Reflections.toString(getter));
        }
        return target -> Reflections.invoke(getter, target, new Object[0]);
    }

    public static <I, O> BiConsumer<I, O> toBiConsumer(Method setter) {
        if (setter.getParameterCount() == 0) {
            throw new IllegalArgumentException("Method is expected to have at least 1 argument but has none : " + Reflections.toString(setter));
        }
        return (target, args) -> Reflections.invoke(setter, target, args);
    }

    public static <K, A> Predicate<K> asPredicate(Function<K, A> function, Predicate<A> predicate) {
        return k -> predicate.test(function.apply(k));
    }

    public static <K, A, V> Function<K, V> link(Function<K, A> firstFunction, Function<A, V> secondFunction) {
        return Functions.chain(new NullProofFunction<K, A>(firstFunction), new NullProofFunction<A, V>(secondFunction));
    }

    public static <K, A, B, V> Function<K, V> link(Function<K, A> firstFunction, Function<A, B> secondFunction, Function<B, V> thirdFunction) {
        return Functions.chain(new NullProofFunction<K, A>(firstFunction), new NullProofFunction<A, B>(secondFunction), new NullProofFunction<B, V>(thirdFunction));
    }

    public static <K, A, V> Function<K, V> chain(Function<K, A> firstFunction, Function<A, V> secondFunction) {
        return firstFunction.andThen(secondFunction);
    }

    public static <K, A, B, V> Function<K, V> chain(Function<K, A> firstFunction, Function<A, B> secondFunction, Function<B, V> thirdFunction) {
        return Functions.chain(firstFunction, secondFunction).andThen(thirdFunction);
    }

    public static class NullProofFunction<I, O>
    implements Function<I, O> {
        private final Function<I, O> surrogate;

        public NullProofFunction(Function<I, O> surrogate) {
            this.surrogate = surrogate;
        }

        @Override
        public O apply(I input) {
            return input == null ? null : (O)this.surrogate.apply(input);
        }

        @Override
        public <V> NullProofFunction<I, V> andThen(Function<? super O, ? extends V> after) {
            Objects.requireNonNull(after);
            return new NullProofFunction<Object, Object>(i -> {
                O result = this.apply((I)i);
                return result == null ? null : after.apply((O)result);
            });
        }
    }
}

