/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.SteppingIterator;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SteppingIteratorTest {
    @Test
    public void testHasNext() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 10L){

            protected void onStep() {
            }
        };
        testInstance.hasNext();
        ((Iterator)Mockito.verify((Object)iterator)).hasNext();
        testInstance.hasNext();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)2))).hasNext();
        testInstance.hasNext();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)3))).hasNext();
    }

    @Test
    public void testNext() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 10L){

            protected void onStep() {
            }
        };
        testInstance.next();
        ((Iterator)Mockito.verify((Object)iterator)).next();
        testInstance.next();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)2))).next();
        testInstance.next();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)3))).next();
    }

    @Test
    public void testRemove() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 10L){

            protected void onStep() {
            }
        };
        testInstance.remove();
        ((Iterator)Mockito.verify((Object)iterator)).remove();
        testInstance.remove();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)2))).remove();
        testInstance.remove();
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)3))).remove();
    }

    @Test
    public void testOnStep() {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true);
        final int[] i = new int[1];
        SteppingIterator<String> testInstance = new SteppingIterator<String>(iterator, 2L){

            protected void onStep() {
                i[0] = i[0] + 1;
            }
        };
        testInstance.hasNext();
        Assertions.assertThat((int)i[0]).isEqualTo(0);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)i[0]).isEqualTo(0);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)i[0]).isEqualTo(1);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)i[0]).isEqualTo(1);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)i[0]).isEqualTo(2);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)false);
        testInstance.next();
        testInstance.hasNext();
        Assertions.assertThat((int)i[0]).isEqualTo(3);
    }
}

